#!/bin/bash -e

SRC=src/linux
CONFIG=config.x86_64

config_equal()
{
	diff -q -s "$SRC/.config" "$CONFIG" &>/dev/null
}

if config_equal; then
	(cd "$SRC" && make menuconfig)
else
	[[ -e "$SRC" ]] && rm -rf "$SRC"
	makepkg --nobuild --force
	(cd "$SRC" && make oldconfig)
fi

if ! config_equal; then
	cp -v "$SRC/.config" "$CONFIG"
	updpkgsums
fi
