#!/bin/bash

if [[ -t 2 ]]; then
  bld=$'\e[1;33m';
  rst=$'\e[m';
else
  bld=''
  rst=''
fi

if (( $# == 0 )); then
  mapfile SRCINFO < <(makepkg --printsrcinfo)
  tag="v$(echo "${SRCINFO[*]}"|awk '/pkgver/ {print $3}')-$(echo "${SRCINFO[*]}"|awk '/pkgrel/ {print $3}')"
  read -r -p "Push $bld$tag$rst? (y/N): " VALIDATE
  [[ $VALIDATE == "y" ]] || exit 1
else
  tag="$1"
fi

set -e
git tag "$tag"
git push origin "$tag"
