#!/bin/bash -x

tarball=/usr/share/dokuwiki/dokuwiki.tgz

# See: https://www.dokuwiki.org/install:upgrade
if [[ -e "$tarball" ]]; then
  pushd /var/www/html > /dev/null

  # Deploy last version from tarball.
  tar --extract --gzip --strip-components=1 --file "$tarball" --no-same-owner

  # Install default .htaccess
  mv .htaccess.dist conf/apache.conf.dist
  [[ -e conf/apache.conf ]] || cp conf/apache.conf.dist conf/apache.conf
  [[ -e .htaccess ]] || ln -s conf/apache.conf .htaccess

  # Set file spermissions.
  chown -cR www-data:www-data conf data lib/{tpl,plugins}
  chmod -c 750 conf data

  # Remove deleted files.
  grep -Ev '^($|#)' data/deleted.files | xargs -n 1 rm -vf

  # Force cache purge
  [ -e conf/local.php ] && touch conf/local.php
  popd > /dev/null
  rm -v "$tarball"
fi

exec docker-php-entrypoint "$@"
