import logging
from ConfigParser import SafeConfigParser


logger = logging.getLogger(__name__)


class NodeConfigParser(object):
    """ConfigParser for ccnode config file."""
    def __init__(self, file_path):
        config = SafeConfigParser()
        config.read(file_path)

        # ccserver settings
        self.server_host = config.get('ccserver', 'host')
        self.server_port = config.getint('ccserver', 'port')
        self.server_user = config.get('ccserver', 'user')
        self.server_passwd = config.get('ccserver', 'password')
        # TODO complete
