from ccnode.hypervisor import lib as libvirt_
from ccnode.utils import and_


# hypervisor related tags
def htype():
    """Hypervisor type."""
    # FIXME for other support
    return u'kvm'


def hv(handl):
    """Hypervisor name."""
    # What is the point of this tag ? if the information not already in a and id
    # ?
    return handl.hypervisor.name


def hvm():
    """Hardware virtualization enable."""
    # see
    # http://www.linux-kvm.org/page/FAQ#How_can_I_tell_if_I_have_Intel_VT_or_AMD-V.3F
    # or
    # http://www.cyberciti.biz/faq/linux-xen-vmware-kvm-intel-vt-amd-v-support/
    # if we are in a xen hypervisor we won't see vt in /proc/cpuinfo
    result = {True: u'yes', False: u'no'}

    if htype() == u'kvm':
        # findout in /proc/cpuinfo if all CPUs have virtualisation enabled
        return result[and_(
            set(
                'vmx',  # Intel VT
                'svm',  # AMD 
            ) & set(
                l.split(': ')[-1].split()
            ) for l in open('/proc/cpuinfo').readline() if l.startswith('Tags')
        )]

    return None


def hvver():
    """Hypervisor version."""
    return libvirt_.connection.getVersion()


def libvirtver():
    """Version of running libvirt."""
    return libvirt_.connection.getLibVersion()


# jobs
def rjobs():
    """Number of currently running jobs."""


# storage pools
def sto(handl):
    """Storage pool names."""
    return u' '.join(handl.hypervisor.storage.storages.iterkeys())


# Vm related tags
def nvm(handl):
    """Number of VMS in the current hypervisor."""
    return handl.hypervisor.vm_total


def vmpaused(handl):
    """Count of VMs paused."""
    return handl.hypervisor.vm_paused


def vmstarted(handl):
    """Count of VMs started."""
    return handl.hypervisor.vm_started


def vmstopped(handl):
    """Count of VMs Stopped."""
    return handl.hypervisor.vm_stopped
