# -*- coding: utf-8 -*-

import socket
import threading
import ssl
import logging
from sjrpc.client import SimpleRpcClient
from sjrpc.utils import ConnectionProxy
from sjrpc.core import RpcError
import handlers
from threading import Timer

class CCNode(object):
    '''
    Handle node initialization, connection to server, and authentication
    '''
    def __init__(self, server, port, hypervisor, exec_cmd, force_xen=False,
                                                                    cert=None):
        '''
        '''
        self._scheduler_timer = None
        self._handler = handlers.NodeHandler(self, hypervisor, exec_cmd,
                                                                    force_xen)
        self._manager = SimpleRpcClient.from_addr(server, port, enable_ssl=True,
                                                default_handler=self._handler)
        self._server = ConnectionProxy(self._manager)
    
    def run(self):
        '''
        '''
        self._manager.run()
    
    def authentify(self, login, password):
        '''
        '''
        logging.debug('Authenticating user %s' % login)
        try:
            role = self._server.authentify(login, password)
            self._scheduler_run()
        except RpcError as err:
            if err.exception == 'AuthenticationError':
                logging.warning('Authentication error')
            else:
                logging.warning('Unknown error while authenticating: %s' % err)
            return False
        except Exception as err:
            logging.debug('Unhandled exception: `%s`' % err)
        else:
            if role != 'hv':
                logging.warning('Bad role affected by server: %s' % role)
                raise Exception()
                # FIXME this will not cause a server restart, node stays dead
            else:
                return True
    
    def _scheduler_run(self):
        '''
        '''
        self._handler.scheduler_run()
        # reset timer
        del self._scheduler_timer
        self._scheduler_timer = Timer(1, self._scheduler_run)
        self._scheduler_timer.start()

    def get_server(self):
        '''
        '''
        return self._server
    
    def get_manager(self):
        '''
        '''
        return self._manager
    
    def get_handler(self):
        '''
        '''
        return self._handler