# -*- coding: utf-8 -*-

from libvirtwrapper import LibvirtHypervisor


class KvmHypervisor(LibvirtHypervisor):
    '''
    Base class of a Kvm Hypervisor
    '''
    _instance = None
    
    def __init__(self):
        '''
        '''
        super(KvmHypervisor, self).__init__('kvm')
    
    def __new__(cls, *args, **kwargs):
        '''
        .. note::
            We use singleton design pattern to force only a single instance
            of our libvirt hypervisor handle, it's essential since we connect
            with libvirt only on localhost so we must assure one single 
            connection to the hypervisor
        '''
        if cls._instance is None:
            cls._instance = super(KvmHypervisor, cls).__new__(cls, *args,
                                                                    **kwargs)
        return cls._instance
