# -*- coding: utf-8 -*-

from threading import Lock

class RWLock(object):
    '''
    '''
    def __init__(self):
        '''
        '''
        self._mutex = Lock()
        self._writemutex = Lock()
        self._readers = 0
        self._writers = 0
        self.read = self._RLock(self)
        self.write = self._WLock(self)
    
    class _Lock(object):
        '''
        '''
        def __init__(self, rwlock):
            '''
            '''
            self._parent = rwlock
    
    class _WLock(_Lock):
        '''
        '''
        def __enter__(self):
            '''
            '''
            with self._parent._mutex:
                self._parent._writers += 1
            self._parent._writemutex.acquire()
        
        def __exit__(self, exc_type, exc_value, traceback):
            '''
            '''
            with self._parent._mutex:
                self._parent._writers -= 1
            self._parent._writemutex.release()
    
    class _RLock(_Lock):
        '''
        '''
        def __enter__(self):
            '''
            '''
            self._parent._mutex.acquire()
            if self._parent._writers > 0 or self._parent._readers == 0:
                self._parent._mutex.release()
                self._parent._writemutex.acquire()
                self._parent._mutex.acquire()
            self._parent._readers += 1
            self._parent._mutex.release()
        
        def __exit__(self, exc_type, exc_value, traceback):
            '''
            '''
            self._parent._mutex.acquire()
            self._parent._readers -= 1
            if self._parent._readers == 0:
                self._parent._writemutex.release()
            self._parent._mutex.release()
