"""Plugins helpers for Cloud Control node."""

from itertools import chain, imap


class Base(object):
    """Example skeleton plugin for cc-node.

    If you want to create your own plugin for the `cc-node` you may create an
    object that would quack just like this one or just inherit from this class.

    """
    def __init__(self, *args, **kwargs):
        """
        :param loop: MainLoop instance
        """
        self.main = kwargs.pop('loop')

        # plugins may define tags (see :mod:`ccnode.tags`)
        self.tag_db = dict(
            __main__=dict(),
            # subobjects tags go here
        )

        # plugins may define handler functions that would be called by the
        # server
        self.rpc_handler = dict()

        # tag_db and rpc_handler can be implemented as properties if more logic
        # is needed

    def __hash__(self):
        """This method is used when registering a plugin in the main loop.

        By default, only one instance is allowed. Subclasses can overide this
        method to change this behaviour.

        """
        return hash(self.__class__.__name__)

    def start(self):
        """Used to start pyev watchers."""
        # start tags
        for tag in chain.from_iterable(
            imap(lambda d: d.itervalues(), self.tag_db.itervalues()),
        ):
            tag.start(self.main.loop)

    def stop(self):
        """Cleanup for plugins, can be used to clean pyev watchers."""

        self.main = None
        # TODO dependencies
