from xml.etree import cElementTree as et
from StringIO import StringIO

from ccnode.tags import ttl, refresh


def uuid(dom):
    """Unique identifier of the domain."""
    return dom.uuid


@ttl(5)
def status(dom):
    return dom.state


def hv(dom):
    #FIXME: what shoud be the value of this tag ?
    return dom.hypervisor.name


def htype(dom):
    return dom.hypervisor.type


def arch(dom):
    """VM CPU architecture."""
    try:
        return dict(i686='x86', x86_64='x64')[et.ElementTree().parse(
            StringIO(dom.lv_dom.XMLDesc(0))).find('os/type').get('arch')]
    except Exception:
        logger.exception('Error while get Architecture tag')


def h(dom):
    """Name of the VM."""
    return dom.name


def cpu(dom):
    """Number of CPU of the VM."""
    return dom.lv_dom.info()[3]


@ttl(10)
@refresh(5)
def cpuuse():
    pass


def mem(dom):
    """Memory currently allocated."""
    return dom.lv_dom.info()[2] * 1024


def memmax(dom):
    """Maximum memory allocation."""
    return dom.lv_dom.info()[1] * 1024


def vncport(dom):
    """VNC port for the VM console access."""
    try:
        return et.ElementTree().parse(
            StringIO(dom.lv_dom.XMLDesc(0))
        ).find('devices/graphics').get('port')
    except Exception:
        logger.exception('VNCPort')


@ttl(10)
@refresh(10)
def disk(dom):
    """Get backend disks."""
    return u' '.join(map(str, xrange(len(dom.disks)))) or None


@ttl(10)
@refresh(10)
def nic(dom):
    """VM network interfaces."""
    return u' '.join(map(str, xrange(len(dom.nics)))) or None
