import signal


def signal_(signum):
    """Decorate a function to register as a handler to the signal."""

    def decorator(func):
        signal.signal(signum, func)
        return func

    return decorator


def and_(iter):
    """Do an and logic condition over the iterable element.

    :param iterable iter: meat for condition
    """
    for i in iter:
        if not i:
            return False

    return True
