"""Exceptions classes for ccnode."""


class CCNodeError(Exception):
    """Base exception class for cc-node."""
    pass


class PluginError(CCNodeError):
    """Exception related to plugin execution."""
    pass


class UndefinedDomain(CCNodeError):
    """Operation on a domain that does not exist was tried."""
    pass


class PoolStorageError(CCNodeError):
    """Pool or volume was not found."""
    pass


class TunnelError(CCNodeError):
    """Error occured during TunnelJob execution."""
    pass


class DRBDAllocationError(CCNodeError):
    """Cannot create DRBD volume."""
    pass


class DRBDError(CCNodeError):
    """Error occured during DRBDJob execution."""
    pass


class ConsoleError(CCNodeError):
    """Error relative to VM virtio console handling."""
    pass


class ConsoleAlreadyOpened(ConsoleError):
    """VM virtio console is already opened."""
    pass


class VMMigrationError(CCNodeError):
    """Error during live migration job."""
    pass


class JobError(CCNodeError):
    """General exception for a job."""
    pass


class RemoteExecutionError(CCNodeError):
    """Thrown when a remote command execution error occurs."""
    pass
