import logging

from ccserver.clients import Client, RegisteredCCHandler
from ccserver.handlers import listed
from ccserver.utils import OrderedSet


class SpvHandler(RegisteredCCHandler):
    """ Handler binded to 'spv' role.
    """

    @listed
    def list(self, query):
        """ List all objects registered on this instance.

        :param query: the query to select objects to show
        """

        logging.debug('Executed list function with query %s', query)
        objects = self.server.list(query)
        return {'objects': objects}


class SpvClient(Client):

    """ A spv client connected to the cc-server.
    """

    ROLE = 'spv'
    RPC_HANDLER = SpvHandler


Client.register_client_class(SpvClient)
