""" This module contains some cc-server specific helpers for the CloudControl
    tags database provided in cc-commons.
"""

from cloudcontrol.common.tql.db.tag import BaseTag
from cloudcontrol.common.tql.db.object import TqlObject


class SObject(TqlObject):

    """ A TQL object with features specific to cc-server.
    """

    def register(self, tag, override=False):
        """ Register a tag on this object (or override).
        """
        if override:
            self._tags[tag.name] = OverrideTag(tag.name, tag, self._tags.get(tag.name))
        else:
            return super(SObject, self).register(tag)


    def unregister(self, name, override=False):
        """ Unregister a tag on this object (or remove override).
        """
        if override:
            if isinstance(self._tags.get(name), OverrideTag):
                if self._tags[name].replaced is not None:
                    self._tags[name] = self._tags[name].replaced
                else:
                    super(SObject, self).unregister(name)
        else:
             if isinstance(self._tags.get(name), OverrideTag):
                 self._tags[name].replaced = None
             else:
                 super(SObject, self).unregister(name)

    def is_overriding(self, name):
        """ Return True if a tag is overriding another one for the name.

        If the tag is not found, False is returned.
        """
        return isinstance(self._tags.get(name), OverrideTag)


class OverrideTag(BaseTag):

    """ A tag to override another one.
    """

    def __init__(self, name, override, replaced=None):
        super(OverrideTag, self).__init__(name)
        self.override = override
        self.replaced = replaced

    def get_value(self):
        return self.override.get_value()

    def set_value(self, value):
        return self.override.set_value(value)
