from setuptools import setup
from distutils.command.build import build
import os
import sys

# Retrieval of version:
from ccserver import __version__

ldesc = open(os.path.join(os.path.dirname(__file__), 'README')).read()

class BuildMan(build):

    '''
    Build command class used by distutil to generate manpages from RST sources
    while packaging.
    '''

    MANPAGES = ('cc-server', 'cc-addaccount')
    description = 'Build manual from RSt source'

    def run(self):
	from docutils.core import publish_file
	from docutils.writers import manpage
	
        srcdir = os.path.split(os.path.abspath(__file__))[0]

	for man in self.MANPAGES:
	    publish_file(source_path=os.path.join(srcdir, 'doc/%s.rst' % man),
			 destination_path=os.path.join(srcdir, '%s.1' % man),
			 writer=manpage.Writer())

build.sub_commands.insert(0, ('build_man', None))

cmdclass = {'build_man': BuildMan}

setup(
    name='cc-server',
    version=__version__,
    description='CloudControl server',
    long_description=ldesc,
    author='Antoine Millet',
    author_email='antoine.millet@smartjog.com',
    license='GPL2', 
    packages=['ccserver'],
    scripts=['bin/cc-server', 'bin/cc-addaccount'],
    data_files=(
        ('/etc/', ('etc/cc-server.conf',)),
    ),
    classifiers=[
        'Operating System :: Unix',
        'Programming Language :: Python',
    ],
    cmdclass=cmdclass
)
