#!/bin/bash

if [ "$1" == "" ]; then
    echo "Usage: $0 <output>"
    exit 1
fi

tmp=$(mktemp -d)
virtualenv -p pypy $tmp
(source $tmp/bin/activate && pip install -t $tmp/packages python-daemon ply \
                          && pip install -t $tmp/packages --no-binary ":all:"  git+ssh://git@git.brane.cloud/adunand/pyev.git \
                          && pip install -t $tmp/packages git+ssh://git@git.brane.cloud/software/sjrpc.git \
                          && pip install -t $tmp/packages --upgrade \
                                git+ssh://git@git.brane.cloud/software/cc-common.git \
                                git+ssh://git@git.brane.cloud/software/cc-server.git)
find $tmp/packages/ | grep -E "(__pycache__|\.pyc|\.pyo$)" | xargs rm -rf
cp $tmp/packages/bin/cc-server $tmp/packages/__main__.py
echo "__import__('pkg_resources').declare_namespace(__name__)" > $tmp/packages/cloudcontrol/__init__.py
python3 -m zipapp $tmp/packages/ -o "$1" -p '/usr/bin/env pypy'
echo "cc-server executable package created in $1"
rm -Rf $tmp
