# This file is part of CloudControl.
#
# CloudControl is free software: you can redistribute it and/or modify
# it under the terms of the GNU Lesser General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# CloudControl is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public License
# along with CloudControl.  If not, see <http://www.gnu.org/licenses/>.


from cloudcontrol.server.clients import Client
from cloudcontrol.server.clients.host import HostClient

from cloudcontrol.server.db import SObject
from cloudcontrol.common.tql.db.tag import StaticTag


class BootstrapClient(HostClient):

    """ A bootstrap client connected to the cc-server.
    """

    ROLE = 'bootstrap'

    def _get_tql_object(self):
        tql_object = SObject(self.login)
        tql_object.register(StaticTag('r', self.role))
        self._server.db.register(tql_object)
        return tql_object

    @property
    def login(self):
        return '%s.%s' % (self._login, self.conn.get_fd())

    @property
    def role(self):
        return 'host'

    def shutdown(self):
        super(BootstrapClient, self).shutdown()
        # Also, remote the object from the db:
        self._server.db.unregister(self.login)


Client.register_client_class(BootstrapClient)
