# This file is part of CloudControl.
#
# CloudControl is free software: you can redistribute it and/or modify
# it under the terms of the GNU Lesser General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# CloudControl is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public License
# along with CloudControl.  If not, see <http://www.gnu.org/licenses/>.


from cloudcontrol.server.clients import Client, RegisteredCCHandler
from cloudcontrol.server.handlers import listed


class SpvHandler(RegisteredCCHandler):
    """ Handler binded to 'spv' role.
    """

    @listed
    def list(self, query):
        """ List all objects registered on this instance.

        :param query: the query to select objects to show
        """

        self.logger.debug('Executed list function with query %s', query)
        objects = self.server.list(query)
        return {'objects': objects}


class SpvClient(Client):

    """ A spv client connected to the cc-server.
    """

    ROLE = 'spv'
    RPC_HANDLER = SpvHandler


Client.register_client_class(SpvClient)
