#!/usr/bin/env python

# This file is part of CloudControl.
#
# CloudControl is free software: you can redistribute it and/or modify
# it under the terms of the GNU Lesser General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# CloudControl is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public License
# along with CloudControl.  If not, see <http://www.gnu.org/licenses/>.


from setuptools import setup, find_packages
import os
import sys

# Retrieval of version:
from cloudcontrol.server import __version__

ldesc = open(os.path.join(os.path.dirname(__file__), 'README')).read()


setup(
    name='cc-server',
    version=__version__,
    description='CloudControl server',
    long_description=ldesc,
    author='Antoine Millet',
    author_email='antoine.millet@smartjog.com',
    license='LGPL3',
    packages=find_packages(exclude=['ez_setup', 'examples', 'tests']),
    scripts=['bin/cc-server', 'bin/cc-addaccount'],
    namespace_packages=['cloudcontrol'],
    data_files=(
        ('etc/', ('etc/cc-server.conf',)),
    ),
    classifiers=[
        'Operating System :: Unix',
        'Programming Language :: Python',
    ],
)
