#!/usr/bin/env python

'''
Simple sjRpc client example.
'''

from __future__ import absolute_import

import sys
import random
import threading

from sjrpc.core import RpcConnection
from sjrpc.utils import RpcHandler

class MyClientHandler(RpcHandler):

    def client_random(self, min=0, max=100):
        print 'Local call to client_random'
        return random.randint(min, max)


# Get arguments from the command line:
if len(sys.argv) < 3:
    print 'Usage: %s <listening address> <listening port>' % sys.argv[0]
    sys.exit(2)
address = sys.argv[1]
port = int(sys.argv[2])

# Create the rpc connection:
conn = RpcConnection.from_addr(address, port, handler=MyClientHandler())

# Run the connection mainloop in another thread:
t = threading.Thread(target=conn.run)
t.daemon = True
t.start()

print 'Random = %s' % (conn.call('proxy', 'client_random'), )

conn.shutdown()
