#!/usr/bin/env python

'''
Simple sjRpc server.
'''

from __future__ import absolute_import

import sys
import random
from sjrpc.server import RpcServer
from sjrpc.utils import RpcHandler, pass_connection


class MyHandler(RpcHandler):

    def random(self, min=0, max=100):
        return random.randint(min, max)

    @pass_connection
    def proxy(self, conn, method, *args, **kwargs):
        '''
        Example of bidirectionnal RPC. When the peer call this method, the
        server forward the call of the specified method the peer, and return
        the value returned by the peer.
        '''
        return conn.call(method, *args, **kwargs)

# Get arguments from the command line:
if len(sys.argv) < 3:
    print 'Usage: %s <listening address> <listening port>' % sys.argv[0]
    sys.exit(2)
address = sys.argv[1]
port = int(sys.argv[2])

# Create the server instance:
rpcserver = RpcServer.from_addr(address, port, conn_kw=dict(handler=MyHandler()))
rpcserver.loop.debug = True

rpcserver.run()
