#!/usr/bin/env python
#coding=utf8

'''
CloudControl alias related command
'''

from cccli.exception import *
from cccli.command.command import OptionCommand
import re

class Command_alias(OptionCommand):
    '''Show or create alias'''

    def __init__(self, cli, argv0):
        OptionCommand.__init__(self, cli, argv0)
        self.set_usage("%prog [options] [name] [value]")

    def __call__(self, argv):
        # args parse
        self.parse_args(argv)
        _value = None
        if len(self.args) == 0:
            _alias = self.cli.alias.keys()
        elif len(self.args) == 1:
            _alias = self.args[0]
        elif len(self.args) == 2:
            _alias = self.args[0]
            _value = self.args[1]
        else:
            raise cmdBadArgument()
        # printing
        if _value is None:
            for a in _alias:
                if a in self.cli.alias:
                    self.printer.out("%s \"%s\""%(a, re.sub("\"", "\\\"", self.cli.alias[a])))
                else:
                    self.printer.warn("No alias %s"%a)
        # editing
        else:
            self.cli.alias[_alias] = _value
            self.cli.alias.save(self.cli.settings.get("alias", ""))


class Command_unalias(OptionCommand):
    '''Remove an alias'''

    def __init__(self, cli, argv0):
        OptionCommand.__init__(self, cli, argv0)
        self.set_usage("%prog [options] [name]")

    def __call__(self, argv):
        # parse args
        self.parse_args(argv)
        if len(self.args) != 1:
            raise cmdBadArgument()
        # check alias existance
        if self.args[0] not in self.cli.alias:
            raise cmdBadArgument("%s: No such alias"%self.args[0])
        # deleting aliases
        del self.cli.alias[self.args[0]]
        self.cli.alias.save(self.cli.settings.get("alias", ""))
