#!/usr/bin/env python
#coding=utf8

'''
CloudControl CLI RPC Handler
'''

import os, os.path
import subprocess
import platform

import cccli
from cccli.exception import *
from cccli.printer import Printer, color

from sjrpc.client import SimpleRpcClient
from sjrpc.utils import RpcHandler, pure
from sjrpc.core.exceptions import *


class CliHandler(RpcHandler):
    '''Handle RPC incoming request'''

    @pure
    def quit(self, rpc=None):
        Printer().fatal("Disconnected from server!")

    @pure
    def get_tags(self, tags=None, resolve=False):
        if tags is None:
            tags = [ x[8:] for x in dir(self) if x.startswith("get_tag_") ]
        d = dict()
        for t in tags:
            method = "get_tag_%s"%t
            if hasattr(self, method):
                d[t] = getattr(self, method)(resolve)
        return d

    def get_tag_version(self, resolve):
        '''Return tag version'''
        return { "value": cccli.version, "ttl": -1 }

    def get_tag_os(self, resolve):
        '''Return Operating system tag'''
        if resolve:
            return { "value": platform.system().lower(), "ttl": -1 }
        return { "ttl": -1 }

    def get_tag_uname(self, resolve):
        '''Return uname output'''
        if resolve:
            try:
                p = subprocess.Popen(["uname", "-a"], close_fds=True, shell=False, stdout=subprocess.PIPE)
                return  { "value": p.stdout.read().rstrip("\n")  , "ttl": -1 }
            except Exception:
                return { "value": "", "ttl": -1 }
        else:
            return { "ttl": -1 }

    def get_tag_uptime(self, resolve):
        '''Return uptime output'''
        if resolve:
            try:
                p = subprocess.Popen(["uptime"], close_fds=True, shell=False, stdout=subprocess.PIPE)
                return  { "value": p.stdout.read().rstrip("\n")  , "ttl": 3 }
            except Exception:
                return { "value": "", "ttl": 3 }
        else:
            return { "ttl": 3 }
