#!/usr/bin/env python
#coding=utf8

'''
CloudControl Connection related commands
'''

from cccli.exception import *
from sjrpc.core.exceptions import *
from cccli.printer import Printer, color
from cccli.command.command import TqlCommand

class Command_uptime(TqlCommand):
    '''Show connection uptime'''

    def __init__(self, cli, argv0):
        TqlCommand.__init__(self, cli, argv0)
        self.set_usage("%prog [options] [tql]")

    def __call__(self, argv):
        # args parse
        self.parse_args(argv)
        if len(self.args) == 0:
            _tql = "a=%s$con"%self.cli.settings["login"]
        else:
            _tql ="".join(self.args) + "$con" 
        objs = self.rpccall("list", _tql)
        for o in objs:
            if "a" in o and "con" in o:
                self.printer.out("%s: %ss"%(o["a"], o["con"]))
