
'''
CloudControl physical host related commands
'''

from cccli.exception import *
from sjrpc.core.exceptions import *
from cccli.printer import Printer, color
from cccli.command.command import Command, OptionCommand

class Command_exec(Command):
    '''Execute a command on the remote host'''
    def __call__(self, argv):
        if len(argv) != 3:
            raise cmdBadArgument()
        try:
            self.cli.rpc.call("exec", argv[1], argv[2])
        except RpcError as e:
            raise cmdError("RPCError: %s"%str(e))

    def usage(self):
        return "Usage: exec <tql> <command>"


class Command_shutdown(OptionCommand):
    '''Shutdown a physical host'''

    def __init__(self, cli, argv0):
        OptionCommand.__init__(self, cli, argv0)
        self.set_usage("%prog [options] <tql>")
        self.add_option("-r", "--reboot", action="store_true", dest="reboot",
                        help="Reboot after shutdown (default)")
        self.add_option("-H", "--halt", action="store_false", dest="reboot",
                        help="Halt after shutdown")
        self.add_option("-n", action="store_false", dest="graceful", default=True,
                        help="do not go through init but go down real fast")

    def __call__(self, argv):
        self.parse_args(argv)
        if len(self.args) != 1:
            raise cmdBadArgument()
        try:
            self.cli.rpc.call("shutdown", self.args[0], self.options.reboot,
                              self.options.graceful)
        except RpcError as e:
            raise cmdError("RPCError: %s"%str(e))
