#!/usr/bin/env python
#coding=utf8

'''
CloudControl alias related command
'''

from cccli.exception import *
from cccli.command.command import Command

class Command_alias(Command):
    '''Show or create alias'''

    def __call__(self, argv):
        if len(argv) == 1:
            for n, v in self.cli.alias.items():
                self.printer.out("%s=%s"%(n, v))
        elif len(argv) == 2:
            if argv[1] not in self.cli.alias:
                raise cmdBadArgument(argv[1])
            self.printer.out("%s=%s"%(argv[1], self.cli.alias[argv[1]]))
        elif len(argv) == 3:
            self.cli.alias[argv[1]] = argv[2]
            self.cli.alias.save(self.cli.settings.get("alias", ""))
        else:
            raise cmdBadArgument()

    def usage(self):
         return "Usage: alias [name] [value]"


class Command_unalias(Command):
    '''Remove an alias'''

    def __call__(self, argv):
        if len(argv) != 2:
            raise cmdBadArgument()
        if argv[1] not in self.cli.alias:
            raise cmdBadArgument("%s: No such alias"%argv[1])
        del self.cli.alias[argv[1]]
        self.cli.alias.save(self.cli.settings.get("alias", ""))

    def usage(self):
        return "Usage: unalias [name]"
