#!/usr/bin/env python
#coding=utf8

'''
CloudControl CLI command module
'''

from optparse import OptionParser

class Command(object):

    def __init__(self, cli, argv0):
        self.cli = cli
        self.printer = self.cli.printer
        self.name = argv0

    def usage(self):
        return "Usage: %s"%self.name

    def help(self):
        return self.__doc__


class OptionCommand(Command):

    def __init__(self, cli, argv0):
        Command.__init__(self, cli, argv0)
        self.option = OptionParser(prog=argv0)

    def usage(self):
        return self.option.format_help().strip()

    def help(self):
        return self.__doc__
