#!/usr/bin/env python
#coding=utf8

'''
CloudControl list command
'''

from cccli.exception import *
from sjrpc.core.exceptions import *
from cccli.printer import Printer, color
from cccli.command.command import OptionCommand

class Command_list(OptionCommand):
    '''List objects'''

    def __init__(self, cli, argv0):
        OptionCommand.__init__(self, cli, argv0)
        self.option.set_usage("%prog [options] <tql>")
        self.option.add_option("-c", action="store_true", dest="table",
                                help="column aligment display")
        self.option.add_option("-l", action="store_true", dest="align",
                                help="line aligment display")

    def __call__(self, argv):
        try:
            (options, args) = self.option.parse_args(argv[1:])
        except SystemExit:
            return
        if len(args) == 0:
            args.append("")
        try:
            objs = self.cli.rpc.call("list", str.join("", args))
        except RpcError as e:
            raise cmdError("RPCError: %s"%str(e))
        if len(objs) == 0:
            return
        if options.align:
            self._list_align(objs)
        elif options.table:
            self._list_table(objs)
        else:
            self._list(objs)

    def _list(self, objs):
        for o in objs:
            id = o.pop("id")
            tags = " ".join([ "%s%s:%s%s"%(color["green"], t, color["reset"], v) for (t,v) in o.items() ])
            self.printer.out("%sid:%s%s%s %s"%(color["green"], color["yellow"], id, color["reset"], tags))

    def _list_align(self, objs):
        # get all tag list
        tags = dict()
        for o in objs:
            for t,v in o.items():
                tags[t] = max(len(str(v)), tags.get(t, len(str(t))))
        for o in objs:
            id = str(o.pop("id"))
            line = "%sid:%s%s%s"%(color["green"], color["yellow"], id.ljust(tags["id"] + 2), color["reset"])
            taglist = o.keys()
            taglist.sort()
            for tagname in taglist:
                line += "%s%s:%s%s"%(color["green"], tagname, color["reset"],
                                     str(o[tagname]).ljust(tags[tagname] + 1))
            self.printer.out(line)

    def _list_table(self, objs):
        # get all tag list
        tags = dict()
        for o in objs:
            for t,v in o.items():
                tags[t] = max(len(str(v)), tags.get(t, len(str(t))))
        # extract id info
        idsize = tags.pop("id")
        # print titles
        self.printer.out(color["green"], nl="")
        self.printer.out("id".ljust(idsize+1), nl=" ")
        for t,v in tags.items():
            self.printer.out(t.ljust(v), nl=" ")
        self.printer.out(color["reset"])
        # print obj
        for obj in objs:
            self.printer.out("%s%s%s"%(color["yellow"], obj.pop("id").ljust(idsize+1), color["reset"]) ,nl=" ")
            for (t, v) in tags.items():
                self.printer.out(str(obj.get(t, "")).ljust(v) ,nl=" ")
            self.printer.out()

