#!/usr/bin/env python
#coding=utf8

'''
CloudControl server command
'''
from cccli.exception import *
from sjrpc.core.exceptions import *
from cccli.printer import Printer, color
from cccli.command.command import OptionCommand

class Command_server(OptionCommand):
    '''Server manipulation command'''

    def __init__(self, cli, argv0):
        OptionCommand.__init__(self, cli, argv0)
        self.option.set_usage("%prog <options>")
        self.option.add_option("-c", action="store_true", dest="cache",
                                help="show server cache")
        self.option.add_option("-l", action="store_true", dest="commands",
                                help="list server commands")
        self.option.add_option("-v", action="store_true", dest="version",
                                help="show server version")


    def __call__(self, argv):
        try:
            (options, args) = self.option.parse_args(argv[1:])
        except SystemExit:
            return
        if len(args) > 0:
            self.printer.out(self.usage())
        elif options.cache:
            self.show_cache()
        elif options.commands:
            self.show_commands()
        elif options.version:
            self.show_version()
        else:
            self.printer.out(self.usage())

    def show_commands(self):
        try:
            for cmds in self.cli.rpc.call("list_commands"):
                self.printer.out("%s"%cmds["name"])
        except RpcError as e:
            raise cmdError("RPCError: %s"%str(e))

    def show_cache(self):
        try:
            d = self.cli.rpc.call("dbstats")
            for i,v in d.items():
                self.printer.out("%s: %s"%(i,v))
        except RpcError as e:
            raise cmdError("RPCError: %s"%str(e))

    def show_version(self):
        try:
            self.printer.out(self.cli.rpc.call("version"))
        except RpcError as e:
            raise cmdError("RPCError: %s"%str(e))
