#!/usr/bin/env python
#coding=utf8

'''
CloudControl tag releated commands
'''

from cccli.exception import *
from sjrpc.core.exceptions import *
from cccli.printer import Printer, color
from cccli.command.command import Command, OptionCommand

from optparse import OptionParser

class Command_tags(OptionCommand):
    '''List static tags on an account'''

    def __init__(self, cli, argv0):
        OptionCommand.__init__(self, cli, argv0)
        self.option.set_usage("%prog [options] [tql]")
        self.option.add_option("--raw", action="store_true", dest="raw",
                               help="Don't append filter on request")
        self.option.add_option("-n", "--no-tagdisplay", action="store_false", dest="tagdisplay", default=True,
                               help="No tag display system")

    def __call__(self, argv):
        # Parse argline
        try:
            (options, args) = self.option.parse_args(argv[1:])
        except SystemExit:
            return
        # handle tagdisplay
        if options.tagdisplay:
            self.td = self.cli.tagdisplay.resolve
            self.tc = self.cli.tagdisplay.color
        else:
            self.td = lambda tagname, tagvalue: unicode(tagvalue)
            self.tc = lambda tagname: color["reset"]
        # append current login if nothing asked
        if len(args) == 0:
            tql = "a=%s"%self.cli.settings["login"]
        else:
            tql = "".join(args)
        # update tql if mode
        if not options.raw:
            tql += "&a"
        # ask server
        try:
            objs = self.cli.rpc.call("tags", tql)
        except RpcError as e:
            raise cmdError("RPCError: %s"%str(e))
        # display answer
        for o in objs:
            id = self.td("id", o.pop("id"))
            tags = " ".join([ "%s%s:%s%s"%(color["reset"],
                                           t,
                                           self.tc(t),
                                           self.td(t, v))
                              for (t,v) in o.items() ])
            self.printer.out("%sid:%s%s %s%s"%(color["reset"], color["lblue"], id, tags, color["reset"]))


class Command_addtag(Command):
    '''Add/Modify a static tag on an account'''

    def __call__(self, argv):
        if len(argv) != 4:
            raise cmdBadArgument()
        try:
            self.cli.rpc.call("addtag", argv[1], argv[2], argv[3])
        except RpcError as e:
            raise cmdError("RPCError: %s"%str(e))

    def usage(self):
        return "Usage: addtag <tql> <tag> <value>"


class Command_deltag(Command):
    '''Delete a static tag from an account'''

    def __call__(self, argv):
        if len(argv) != 3:
            raise cmdBadArgument()
        try:
            self.cli.rpc.call("deltag", argv[1], argv[2])
        except RpcError as e:
            raise cmdError("RPCError: %s"%str(e))

    def usage(self):
        return "Usage: deltag <tql> <tag>"
