#!/usr/bin/env python
#coding=utf8

'''
CloudControl tagdisplay command
'''
from cccli.exception import *
from sjrpc.core.exceptions import *
from cccli.printer import Printer, color
from cccli.command.command import OptionCommand

class Command_tagdisplay(OptionCommand):
    '''Tagdisplay tool'''

    def __init__(self, cli, argv0):
        OptionCommand.__init__(self, cli, argv0)
        self.option.set_usage("%prog [options] [tag] ...")
        self.option.add_option("-c", action="store", dest="setcolor",
                               help="Set color SETCOLOR to tags")
        self.option.add_option("-t", action="store", dest="settype",
                               help="Set type SETTYPE to tags")
        self.option.add_option("-C", action="store_true", dest="delcolor",
                               help="Remove custom tags color")
        self.option.add_option("-T", action="store_true", dest="deltype",
                               help="Remove custom tags type")
        self.option.add_option("--list-colors", action="store_true", dest="listcolor",
                               help="List allowed color")
        self.option.add_option("--list-types", action="store_true", dest="listtype",
                               help="List allowed types")

    def __call__(self, argv):
        try:
            (options, args) = self.option.parse_args(argv[1:])
        except SystemExit:
            return
        if options.listcolor:
            self.list("color")
        elif options.listtype:
            self.list("type")
        elif len(args) > 0 and options.setcolor:
            self.set("color", args, options.setcolor)
        elif len(args) > 0 and options.delcolor:
            self.set("color", args, None)
        elif len(args) > 0 and options.settype:
            self.set("type", args, options.settype)
        elif len(args) > 0 and options.deltype:
            self.set("type", args, None)
        elif len(args) == 0:
            self.list("my")
        else:
            self.printer.out(self.usage())

    def list(self, what):
        '''List displaytag information'''
        if what == "color":
            self.printer.out("%sTag allowed colors:%s"%(color["lblue"],  color["reset"]))
            for c in color.keys():
                if c.isalpha():
                    self.printer.out(c)
        elif what == "type":
            self.printer.out("%sTag allowed types:%s"%(color["lblue"], color["reset"]))
            for t in self.cli.tagdisplay.types:
                self.printer.out(t)
        elif what == "my":
            self.printer.out("%sMy tag colors:%s"%(color["lblue"], color["reset"]))
            for (u,v) in self.cli.tagdisplay.tagcolor.items():
                self.printer.out("%s: %s"%(u,v))
            self.printer.out("%sMy tag types:%s"%(color["lblue"], color["reset"]))
            for (u,v) in self.cli.tagdisplay.tagtype.items():
                self.printer.out("%s: %s"%(u,v))
        else:
            raise AttributeError

    def set(self, what, tags, value):
        '''Set displaytag info'''
        # crazy gard
        if not len(tags) > 0:
            return
        # set appropriate database
        if what == "color":
            db = self.cli.tagdisplay.tagcolor
            vdb = [ c for c in color.keys() if c.isalpha() ]
        elif what == "type":
            db = self.cli.tagdisplay.tagtype
            vdb = self.cli.tagdisplay.types
        else:
            raise AttributeError
        # check attribute
        if value is not None and value not in vdb:
            self.printer.error("Invalid value: %s"%value)
            return
        # update db
        for tagname in tags:
            if value is None:
                if tagname in db:
                    del db[tagname]
            else:
                db[tagname] = value
        self.cli.tagdisplay.save(self.cli.settings.get("tagdisplay", ""))
