#!/usr/bin/env python
#coding=utf8

'''
CloudControl CLI command module
'''

from cccli.printer import Printer, color
from optparse import OptionParser

class Command(object):
    '''Base of all command class'''

    def __init__(self, cli, argv0):
        self.cli = cli
        self.printer = self.cli.printer
        self.name = argv0

    def __call__(self, argv):
        raise NotImplementedError

    def usage(self):
        return "Usage: %s"%self.name

    def help(self):
        return self.__doc__


class OptionCommand(Command):
    '''Add options parser to Command'''

    def __init__(self, cli, argv0):
        Command.__init__(self, cli, argv0)
        self.option = OptionParser(prog=argv0)

    def usage(self):
        return self.option.format_help().strip()


class TqlCommand(OptionCommand):
    '''Add Tql stuff to Command'''

    def __init__(self, cli, argv0):
        OptionCommand.__init__(self, cli, argv0)
        self.rpc = cli.rpc
        self.option.set_usage("%prog [options] <tql>")
        # set tql status stuff
        self.option.add_option("-s", "--status", action="store_true", dest="status",
                               help="Show status of each tql object")
        # set tagdisplay stuff
        self.tdr = self.cli.tagdisplay.resolve
        self.tdc = self.cli.tagdisplay.color
        self.option.add_option("-n", "--no-tagdisplay", action="callback", dest="tagdisplay",
                               callback=self.opt_notagdisplay,
                               help="No tagdisplay system")

    def opt_notagdisplay(self, option, opt, value, parser):
        '''Callback for option --no-tagdisplay'''
        self.tdr = lambda tagname, tagvalue: tagvalue
        self.tdc = lambda tagname: color["reset"]

    def show_status(self, ans):
        '''Show status of an Tql request'''
        for o in ans:
            s = "%sid: %s%s %sstatus: %s%s %smessage:%s%s%s"%(
                color["reset"], self.tdc("id"), self.tdr("id", o),
                color["reset"], self.tdc(""), ans[o][0],
                color["reset"], self.tdc(""), ans[o][1],
                color["reset"])
            self.printer.out(s)
