
'''
CloudControl physical host related commands
'''

from cccli.exception import *
from sjrpc.core.exceptions import *
from cccli.printer import Printer, color
from cccli.command.command import Command

class Command_exec(Command):
    '''Execute a command on the remote host'''
    def __call__(self, argv):
        if len(argv) != 3:
            raise cmdBadArgument()
        try:
            self.cli.rpc.call("exec", argv[1], argv[2])
        except RpcError as e:
            raise cmdError("RPCError: %s"%str(e))

    def usage(self):
        return "Usage: exec <tql> <command>"

class Command_shutdown(Command):
    '''Shutdown a physical host'''
    def __call__(self, argv):
        if len(argv) != 2:
            raise cmdBadArgument()
        try:
            self.cli.rpc.call("shutdown", argv[1])
        except RpcError as e:
            raise cmdError("RPCError: %s"%str(e))

    def usage(self):
        return "Usage: shutdown <tql>"
