#!/usr/bin/env python
#coding=utf8

'''
CloudControl tag releated commands
'''

from cccli.exception import *
from sjrpc.core.exceptions import *
from cccli.printer import Printer, color
from cccli.command.command import OptionCommand, TqlCommand

from optparse import OptionParser

class Command_tags(OptionCommand):
    '''List static tags on an account'''

    def __init__(self, cli, argv0):
        OptionCommand.__init__(self, cli, argv0)
        self.set_usage("%prog [options] [tql]")
        self.add_option("--raw", action="store_true", dest="raw",
                        help="Don't append filter on request")
        self.add_option("-n", "--no-tagdisplay", action="store_false", dest="tagdisplay", default=True,
                        help="No tag display system")

    def __call__(self, argv):
        # Parse argline
        self.parse_args(argv)
        # handle tagdisplay
        if self.options.tagdisplay:
            self.td = self.cli.tagdisplay.resolve
            self.tc = self.cli.tagdisplay.color
        else:
            self.td = lambda tagname, tagvalue: unicode(tagvalue)
            self.tc = lambda tagname: color["reset"]
        # append current login if nothing asked
        if len(self.args) == 0:
            tql = "a=%s"%self.cli.settings["login"]
        else:
            tql = "".join(self.args)
        # update tql if mode
        if not self.options.raw:
            tql += "&a"
        # ask server
        try:
            objs = self.cli.rpc.call("tags", tql)
        except RpcError as e:
            raise cmdError("RPCError: %s"%str(e))
        # display answer
        for o in objs:
            id = self.td("id", o.pop("id"))
            tags = " ".join([ "%s%s:%s%s"%(color["reset"],
                                           t,
                                           self.tc(t),
                                           self.td(t, v))
                              for (t,v) in o.items() ])
            self.printer.out("%sid:%s%s %s%s"%(color["reset"], color["lblue"], id, tags, color["reset"]))


class Command_addtag(TqlCommand):
    '''Add/Modify a static tag on an account'''

    def __init__(self, cli, argv0):
        TqlCommand.__init__(self, cli, argv0)
        self.set_usage("%prog [options] <tql> <tag> <value>")

    def __call__(self, argv):
        # argv check
        self.parse_args(argv)
        if len(self.args) != 3:
            raise cmdBadArgument()
        # rpc call
        self.rpccall("addtag", self.args[0], self.args[1], self.args[2])


class Command_deltag(TqlCommand):
    '''Delete a static tag from an account'''

    def __init__(self, cli, argv0):
        TqlCommand.__init__(self, cli, argv0)
        self.set_usage("%prog [options] <tql> <tag>")

    def __call__(self, argv):
        # argv check
        self.parse_args(argv)
        if len(self.args) != 2:
            raise cmdBadArgument()
        # rpc call
        self.rpccall("deltag", self.args[0], self.args[1])
