#!/usr/bin/env python
#coding=utf8

'''
CloudControl CLI Printers
'''

import sys

###############################################################################
color = {
    # regular
    "red": "\033[0;31m",
    "green": "\033[0;32m",
    "yellow": "\033[0;33m",
    "blue": "\033[0;34m",
    "purple": "\033[0;35m",
    "cyan": "\033[0;36m",
    "white": "\033[0;37m",
    # lighted
    "lred": "\033[1;31m",
    "lgreen": "\033[1;32m",
    "lyellow": "\033[1;33m",
    "lblue": "\033[1;34m",
    "lpurple": "\033[1;35m",
    "lcyan": "\033[1;36m",
    "lwhite": "\033[1;37m",
    # underline
    "ured": "\033[4;31m",
    "ugreen": "\033[4;32m",
    "uyellow": "\033[4;33m",
    "ublue": "\033[4;34m",
    "upurple": "\033[4;35m",
    "ucyan": "\033[4;36m",
    # others
    "reset": "\033[m",
    }

###############################################################################
def out(message, fd=sys.stdout, nl="\n"):
    '''Print a message in fd ended by nl'''
    fd.write("%s%s"%(message,nl))
    fd.flush()

###############################################################################
def err(message, fd=sys.stderr, nl="\n"):
    out(message, fd, nl)

###############################################################################
def fatal(message, exitcode=42, fd=sys.stderr, nl="\n"):
    out("%sFatal Error:%s %s.%s"%(color["lred"],
                                  color["red"],
                                  message,
                                  color["reset"])
        ,fd,nl)
    if exitcode >= 0:
        sys.exit(exitcode)

###############################################################################
def error(message, fd=sys.stderr, nl="\n"):
    out("%sError:%s %s.%s"%(color["lred"],
                              color["red"],
                              message,
                              color["reset"])
        ,fd,nl)

###############################################################################
def warn(message, fd=sys.stderr, nl="\n"):
    out("%sWarning:%s %s.%s"%(color["lyellow"],
                              color["yellow"],
                              message,
                              color["reset"])
        ,fd,nl)

