#!/usr/bin/env python
#coding=utf8

'''
CloudControl accounts related commands
'''

from cccli.exception import *
from sjrpc.core.exceptions import *
from cccli.printer import Printer, color
from cccli.command import TqlCommand

class Command_addaccount(TqlCommand):
    '''Create an account'''

    def __init__(self, cli, argv0):
        TqlCommand.__init__(self, cli, argv0)
        self.remove_option("--direct")
        self.remove_option("--raw")
        self.set_usage("%prog [options] <account name> <role> [password]")

    def __call__(self, argv):
        # parse args
        self.parse_args(argv)
        if len(self.args) == 2:
            _pass = None
        elif len(self.args) == 3:
            _pass = self.args[2]
            if self.printer.isinteractive():
                self.printer.warn("Password detected, removing last line from history")
                self.printer.history.removelast()
        else:
            raise cmdBadArgument()
        try:
            # add account
            self.cli.rpc.call("addaccount", self.args[0], self.args[1])
        except RpcError as e:
            raise cmdError("RPCError: %s"%str(e))
        # set password
        if _pass is not None:
            self.rpccall("passwd", "a=%s"%self.args[0], _pass, _direct=True)

    def remote_functions(self):
        return set(("addaccount", "passwd"))


class Command_delaccount(TqlCommand):
    '''Delete an account'''

    def __init__(self, cli, argv0):
        TqlCommand.__init__(self, cli, argv0)
        self.tql_filter += "&a"

    def __call__(self, argv):
        self.parse_args(argv)
        if len(self.args) != 1:
            raise cmdBadArgument("<tql>")
        self.rpccall("delaccount", self.args[0])

    def remote_functions(self):
        return set(("delaccount",))


class Command_close(TqlCommand):
    '''Disable accounts'''

    def __init__(self, cli, argv0):
        TqlCommand.__init__(self, cli, argv0)
        self.tql_filter += "&a&-close"

    def __call__(self, argv):
        self.parse_args(argv)
        if len(self.args) != 1:
            raise cmdBadArgument("<tql>")
        self.rpccall("close", self.args[0])

    def remote_functions(self):
        return set(("close",))


class Command_declose(TqlCommand):
    '''Enable accounts'''

    def __init__(self, cli, argv0):
        TqlCommand.__init__(self, cli, argv0)
        self.tql_filter += "&a&close"

    def __call__(self, argv):
        self.parse_args(argv)
        if len(self.args) != 1:
            raise cmdBadArgument("<tql>")
        self.rpccall("declose", self.args[0])

    def remote_functions(self):
        return set(("declose",))


class Command_passwd(TqlCommand):
    '''Change account password'''

    def __init__(self, cli, argv0):
        TqlCommand.__init__(self, cli, argv0)
        self.tql_filter += "&a"

    def __init__(self, cli, argv0):
        TqlCommand.__init__(self, cli, argv0)
        self.set_usage("%prog [options] [tql] [password]")

    def __call__(self, argv):
        # parse args
        self.parse_args(argv)
        _tql = None
        _pass = None
        if len(self.args) == 0:
            _tql = "a=%s"%self.cli.settings["login"]
        elif len(self.args) == 1:
            _tql = self.args[0]
        elif len(self.args) == 2:
            _tql = self.args[0]
            _pass = self.args[1]
            _check = self.args[1]
            if self.printer.isinteractive():
                self.printer.warn("Removing last line from history")
                self.printer.history.removelast()
        else:
            raise cmdBadArgument()
        # get password
        if _pass is None:
            _pass = self.printer.getpass("Password: ")
            _check = self.printer.getpass("Again: ")
        if _pass != _check:
            raise cmdError("You don't type twice the same password. Aborted")
        # execute command
        self.rpccall("passwd", _tql, _pass)

    def remote_functions(self):
        return set(("passwd",))
