
'''
CloudControl execute command
'''

from cccli.exception import *
from sjrpc.core.exceptions import *
from cccli.printer import Printer, color
from cccli.command import TqlCommand

class Command_execute(TqlCommand):
    '''Execute a command on the remote host'''

    def __init__(self, cli, argv0):
        TqlCommand.__init__(self, cli, argv0)
        self.set_usage("%prog [options] <tql> <command>")
        self.tql_filter += "&con&r~'host|hv'"

    def __call__(self, argv):
        # arg parse
        self.parse_args(argv)
        if len(self.args) != 2:
            raise cmdBadArgument()
        # rpc call
        self.rpccall("execute", self.args[0], self.args[1], _callback=self._cb_print_output)

    def _cb_print_output(self, d):
        '''Print output of execute by object'''
        for o in d["objects"]:
            self.printer.out("%sid:%s%s%s output:"%(self.tdtc("id"), self.tdc("id"),
                                                    o["id"], color["reset"]))
            self.printer.out(o.get("output", ""), nl="")

    def remote_functions(self):
        return set(("execute",))
