#!/usr/bin/env python
#coding=utf8

'''
CloudControl shells related commands
'''

from cccli.exception import *
from cccli.printer import Printer, color
from cccli.command import Command

class Command_quit(Command):
    '''Quit application with respect'''
    def __call__(self, argv):
        if len(argv) != 1:
            raise cmdBadArgument()
        raise SystemExit()


class Command_version(Command):
    '''Print cli version'''
    def __call__(self, argv):
        if len(argv) != 1:
            raise cmdBadArgument()
        import cccli
        self.printer.out(cccli.version)


class Command_whoami(Command):
    '''Show connection login'''

    def __call__(self, argv):
        if len(argv) != 1:
            raise cmdBadArgument()
        self.printer.out(self.cli.settings["login"])


class Command_history(Command):
    '''Show commands history'''
    def __call__(self, argv):
        if len(argv) != 1:
            raise cmdBadArgument()
        if not self.printer.history:
            raise cmdError("not available")
        for l in self.printer.history:
            self.printer.out(l)


class Command_clear(Command):
    '''Clear tty'''

    def __call__(self, argv):
        if len(argv) != 1:
            raise cmdBadArgument()
        self.printer.out("\033[H\033[2J", nl="")


class Command_help(Command):
     '''Print help'''
     def __call__(self, argv):
         if len(argv) == 1:
             # printing commands list
             width = max(map(len, self.cli.commands)) + 3
             self.printer.out("%sCommands:%s"%(color["lwhite"], color["reset"]))
             for c in sorted(self.cli.commands):
                 line = "%s"%c
                 line = line.ljust(width,)
                 line += "- %s"%self.cli.commands.help(c)
                 self.printer.out(line)
         elif len(argv) == 2:
             if argv[1] not in self.cli.commands:
                 raise cmdBadArgument(argv[1])
             c = self.cli.commands
             for u in (c.help(argv[1]), c.usage(argv[1])):
                 if u != "":
                     self.printer.out(u)
         else:
             raise cmdBadArgument()

     def usage(self):
         return "Usage: help [command]"


class Command_usage(Command):
    '''Print usage of a command'''

    def __call__(self, argv):
        if len(argv) != 2:
            raise cmdBadArgument()
        if argv[1] not in self.cli.commands:
            raise cmdBadArgument(argv[1])
        usage = self.cli.commands.usage(argv[1])
        if usage is None:
            self.printer.out("No usage.")
        else:
            self.printer.out(usage)

    def usage(self):
        return "Usage: usage <command>"
