
'''
CloudControl physical host related commands
'''

from cccli.exception import *
from sjrpc.core.exceptions import *
from cccli.printer import Printer, color
from cccli.command import TqlCommand

class Command_shutdown(TqlCommand):
    '''Shutdown a physical host'''

    def __init__(self, cli, argv0):
        TqlCommand.__init__(self, cli, argv0)
        self.set_usage("%prog [options] <tql>")
        self.add_option("-R", "--reboot", action="store_true", dest="reboot", default=True,
                        help="Reboot after shutdown (default)")
        self.add_option("-H", "--halt", action="store_false", dest="reboot",
                        help="Halt after shutdown")
        self.add_option("-F", action="store_false", dest="graceful", default=True,
                        help="do not go through init but go down real fast")
        self.tql_filter += "&con&r~'host|hv'"


    def __call__(self, argv):
        # arg parse
        self.parse_args(argv)
        if len(self.args) != 1:
            raise cmdBadArgument()
        self.rpccall("shutdown", self.args[0], self.options.reboot,
                     self.options.graceful)

    def remote_functions(self):
        return set(("shutdown",))
