#!/usr/bin/env python
#coding=utf8

'''
CloudControl watch command
'''

import time as systime

from cccli.exception import *
from sjrpc.core.exceptions import *
from cccli.printer import Printer, color
from cccli.command import OptionCommand


class Command_watch(OptionCommand):
    '''Show output of a repeated command'''

    def __init__(self, cli, argv0):
        OptionCommand.__init__(self, cli, argv0)
        self.set_usage("%prog [options] command [options]")
        self.add_option("-n", "--interval", dest="seconds", type="float", default=1.0,
                        help="Define interval in seconds")

    def __call__(self, argv):
        # Parse argline
        self.parse_args(argv)
        if len(self.args) == 0:
            raise cmdBadArgument()
        while True:
            self.args = self.cli.aliases.substitute(self.args)
            # Clear tty
            self.cli.commands(["clear"])
            # Execute command
            self.cli.commands(self.args)
            systime.sleep(self.options.seconds)
