#!/usr/bin/env python
#coding=utf8

'''
CloudControl right releated commands
'''

from cccli.exception import *
from sjrpc.core.exceptions import *
from cccli.printer import Printer, color
from cccli.command.command import Command, OptionCommand

class Command_rights(OptionCommand):
    '''List account rights'''

    def __init__(self, cli, argv0):
        OptionCommand.__init__(self, cli, argv0)
        self.option.set_usage("%prog [options] [tql]")
        self.option.add_option("--raw", action="store_true", dest="raw",
                               help="Don't append filter on request")

    def __call__(self, argv):
        # Parse argline
        try:
            (options, args) = self.option.parse_args(argv[1:])
        except SystemExit:
            return
        # append current login if nothing asked
        if len(args) == 0:
            tql = "a=%s"%self.cli.settings["login"]
        else:
            tql = "".join(args)
            # update tql if mode
            if not options.raw:
                tql += "&a"
        # ask server
        try:
            al = self.cli.rpc.call("rights", tql)
        except RpcError as e:
            raise cmdError("RPCError: %s"%str(e))
        # display answer
        for (a, rl) in al.items():
            self.printer.out("%srights of %s%s"%(color["lblue"], a, color["reset"]))
            for i,r in enumerate(rl):
                tags = " ".join([ "%s%s:%s%s"%(color["green"], t, color["reset"], v) for (t,v) in r.items() ])
                self.printer.out("[%s] %s"%(i,tags))


class Command_addright(Command):
    '''Add or edit account right'''

    def __call__(self, argv):
        if len(argv) != 5:
            raise cmdBadArgument()
        try:
            self.cli.rpc.call("addright", argv[1], argv[2], argv[3], argv[4])
        except RpcError as e:
            raise cmdError("RPCError: %s"%str(e))

    def usage(self):
        return '''Usage: addright <account tql> <right tql> <method> <target>

<method> is the name of the rpc command to allow
<target> can be allow or deny'''


class Command_delright(Command):
    '''Delete account right'''

    def __call__(self, argv):
        if len(argv) != 3:
            raise cmdBadArgument()
        try:
            self.cli.rpc.call("delright", argv[1], int(argv[2]))
        except RpcError as e:
            raise cmdError("RPCError: %s"%str(e))

    def usage(self):
        return "Usage: delright <account> <index>"
