#!/usr/bin/env python
#coding=utf8

'''
CloudControl accounts related commands
'''

from cccli.exception import *
from sjrpc.core.exceptions import *
from cccli.printer import Printer, color
from cccli.command.command import Command, TqlCommand

class Command_addaccount(Command):
    '''Create an account'''

    def __call__(self, argv):
        if len(argv) != 3:
            raise cmdBadArgument()
        try:
            self.cli.rpc.call("addaccount", argv[1], argv[2])
        except RpcError as e:
            raise cmdError("RPCError: %s"%str(e))

    def usage(self):
        return "Usage: addaccount <account name> <role>"


class Command_delaccount(TqlCommand):
    '''Delete an account'''

    def __call__(self, argv):
        self.parse_args(argv)
        if len(self.args) != 1:
            raise cmdBadArgument("<tql>")
        self.rpccall("delaccount", self.args[0])


class Command_close(TqlCommand):
    '''Disable accounts'''

    def __call__(self, argv):
        self.parse_args(argv)
        if len(self.args) != 1:
            raise cmdBadArgument("<tql>")
        self.rpccall("close", self.args[0])


class Command_declose(TqlCommand):
    '''Enable accounts'''

    def __call__(self, argv):
        self.parse_args(argv)
        if len(self.args) != 1:
            raise cmdBadArgument("<tql>")
        self.rpccall("declose", self.args[0])


class Command_passwd(Command):
    '''Change account password'''

    def __call__(self, argv):
        if len(argv) == 1:
            argv.append("a=%s"%self.cli.settings["login"])
        if len(argv) == 2:
            a = self.printer.getpass("Password: ")
            b = self.printer.getpass("Again: ")
            if a != b:
                raise cmdError("You don't type twice the same password. Aborted")
            argv.append(a)
        elif len(argv) == 3:
            if self.cli.interactive:
                s = "You cannot set password with clear argument in interactive mode.\n"
                s += "*** Think to clean your history! ***"
                raise cmdError(s)
        else:
            raise cmdBadArgument()
        try:
            self.cli.rpc.call("passwd", argv[1], argv[2])
        except RpcError as e:
            raise cmdError("RPCError: %s"%str(e))

    def usage(self):
        return "Usage: passwd [tql] [password]"
