#!/usr/bin/env python
#coding=utf8

'''
CloudControl expert command
'''
from cccli.exception import *
from cccli.printer import Printer, color
from cccli.command import Command
from sjrpc.utils import ConnectionProxy
import code

class Command_expert(Command):
    '''Switch in expert mode'''

    def __call__(self, argv):
        if len(argv) != 1:
            raise cmdBadArgument()
        h = list(self.printer.history)
        self.printer.history.read(self.cli.settings.get("expert", ""))
        try:
            local = dict()
            local["cli"] = self.cli
            local["rpc"] = self.cli.rpc
            local["proxy"] = ConnectionProxy(self.cli.rpc)
            c = code.InteractiveConsole(local)
            c.interact("Use Ctrl+D to go back in CLI. Type dir() to see variables.")
        finally:
            self.printer.history.write(self.cli.settings.get("expert", None))
            self.printer.history.load(h)


    def usage(self):
        return "usage: expert"
