#!/usr/bin/env python
#coding=utf8

'''
CloudControl server command
'''
from cccli.exception import *
from sjrpc.core.exceptions import *
from cccli.printer import Printer, color
from cccli.command.command import RemoteCommand

class Command_server(RemoteCommand):
    '''Server manipulation command'''

    def __init__(self, cli, argv0):
        RemoteCommand.__init__(self, cli, argv0)
        self.set_usage("%prog <options>")
        self.add_option("-c", action="store_true", dest="cache",
                        help="show server cache")
        self.add_option("-f", action="store_true", dest="functions",
                        help="show server functions")
        self.add_option("-v", action="store_true", dest="version",
                        help="show server version")

    def __call__(self, argv):
        self.parse_args(argv)
        if len(self.args) > 0:
            self.printer.out(self.usage())
        elif self.options.cache:
            self.show_cache()
        elif self.options.functions:
            self.show_functions()
        elif self.options.version:
            self.show_version()
        else:
            self.printer.out(self.usage())

    def remote_functions(self):
        return set(('dbstats', 'version'))

    def show_functions(self):
        try:
            for cmds in self.cli.rpc.call("functions"):
                self.printer.out("%s"%cmds["name"])
        except RpcError as e:
            raise cmdError("RPCError: %s"%str(e))

    def show_cache(self):
        try:
            d = self.cli.rpc.call("dbstats")
            for i,v in d.items():
                self.printer.out("%s: %s"%(i,v))
        except RpcError as e:
            raise cmdError("RPCError: %s"%str(e))

    def show_version(self):
        try:
            self.printer.out(self.cli.rpc.call("version"))
        except RpcError as e:
            raise cmdError("RPCError: %s"%str(e))
