#!/usr/bin/env python
#coding=utf8

'''
CloudControl list command
'''

from cccli.exception import *
from sjrpc.core.exceptions import *
from cccli.printer import Printer, color
from cccli.command.command import TqlCommand

class Command_list(TqlCommand):
    '''List objects'''

    def __init__(self, cli, argv0):
        TqlCommand.__init__(self, cli, argv0)
        self.set_usage("%prog [options] [tql]")
        self.add_option("-t", action="store_true", dest="table",
                        help="column aligment display")
        self.add_option("-l", action="store_true", dest="align",
                        help="line aligment display")
        self.remove_option("-s")

    def __call__(self, argv):
        self.parse_args(argv)
        if len(self.args) == 0:
            self.args.append("")
        objs = self.rpccall("list", str.join("", self.args), _status=False)
        if len(objs) == 0:
            return
        if self.options.align:
            self._list_align(objs)
        elif self.options.table:
            self._list_table(objs)
        else:
            self._trivial_list(objs)

    def _trivial_list(self, objs):
        '''Trivial listing of tag'''
        for o in objs:
            id = self.tdr("id", o.pop("id"))
            tags = " ".join([ "%s%s:%s%s"%(self.tdtc(t),
                                           t,
                                           self.tdc(t),
                                           self.tdr(t, v))
                              for (t,v) in o.items() ])
            self.printer.out("%sid=%s%s %s%s"%(self.tdtc("id"), self.tdc("id"), id, tags, color["reset"]))

    def _list_align(self, objs):
        '''Listing line aligned'''
        # get max size by tag
        tags = dict()
        for o in objs:
            for t,v in o.items():
                tags[t] = max(len(self.tdr(t, v)), tags.get(t, len(t)))
        # extract id size
        idsize = tags.pop("id")
        # dislay each object by line
        for o in objs:
            # show id tag
            line = "%sid=%s%s"%(self.tdtc("id"),
                                self.tdc("id"),
                                self.tdr("id", o.pop("id")).ljust(idsize + 2))
            # show others tags
            for tagname in sorted(tags.keys()):
                line += "%s%s:%s%s"%(self.tdtc(tagname),
                                      tagname,
                                      self.tdc(tagname),
                                      self.tdr(tagname, o.get(tagname, u"")).ljust(tags[tagname] + 1))
            self.printer.out("%s%s"%(line, color["reset"]))

    def _list_table(self, objs):
        '''Listing table style'''
        # get max size by tag
        tags = dict()
        for o in objs:
            for t,v in o.items():
                tags[t] = max(len(self.tdr(t, v)), tags.get(t, len(t)))
        # extract id size
        idsize = tags.pop("id")
        # print id title
        self.printer.out(self.tdtc("id"), nl="")
        self.printer.out("id".ljust(idsize+1), nl=" ")
        # print others titles
        for t,v in tags.items():
            self.printer.out(self.tdtc(t), nl="")
            self.printer.out(t.ljust(v), nl=" ")
        self.printer.out(color["reset"])
        # print obj
        for obj in objs:
            # print id first
            self.printer.out(self.tdc("id"), nl="")
            self.printer.out(self.tdr("id", obj.pop("id")).ljust(idsize+1), nl=" ")
            # print others tags
            for (t, v) in tags.items():
                self.printer.out(self.tdc(t), nl="")
                self.printer.out(self.tdr(t, obj.get(t, u"")).ljust(v) ,nl=" ")
            self.printer.out(color["reset"])
