#!/usr/bin/env python
#coding=utf8

'''
CloudControl tagdisplay command
'''
from cccli.exception import *
from sjrpc.core.exceptions import *
from cccli.printer import Printer, color
from cccli.command.command import OptionCommand

class Command_tagdisplay(OptionCommand):
    '''Tagdisplay tool'''

    def __init__(self, cli, argv0):
        OptionCommand.__init__(self, cli, argv0)
        self.set_usage("%prog [options] [tag] ...")
        self.add_option("-c", action="store", dest="setcolor",
                        help="Set custom color on [tag] ")
        self.add_option("-C", action="store_true", dest="delcolor",
                        help="Remove custom color on [tag]")
        self.add_option("-t", action="store", dest="settype",
                        help="Set custom type on [tag]")
        self.add_option("-T", action="store_true", dest="deltype",
                        help="Remove custom type on [tag]")
        self.add_option("-f", action="store", dest="settitlecolor",
                        help="Set custom title color on [tag]")
        self.add_option("-F", action="store_true", dest="deltitlecolor",
                        help="Remove custom title color on [tag]")
        self.add_option("--list-colors", action="store_true", dest="listcolor",
                        help="List allowed color")
        self.add_option("--list-types", action="store_true", dest="listtype",
                        help="List allowed types")

    def __call__(self, argv):
        self.parse_args(argv)
        if self.options.listcolor:
            self.list("color")
        elif self.options.listtype:
            self.list("type")
        elif len(self.args) > 0 and self.options.setcolor:
            self.set("color", self.args, self.options.setcolor)
        elif len(self.args) > 0 and self.options.delcolor:
            self.set("color", self.args, None)
        elif len(self.args) > 0 and self.options.settitlecolor:
            self.set("titlecolor", self.args, self.options.settitlecolor)
        elif len(self.args) > 0 and self.options.deltitlecolor:
            self.set("titlecolor", self.args, None)
        elif len(self.args) > 0 and self.options.settype:
            self.set("type", self.args, self.options.settype)
        elif len(self.args) > 0 and self.options.deltype:
            self.set("type", self.args, None)
        elif len(self.args) == 0:
            self.list("my")
        else:
            self.printer.out(self.usage())

    def list(self, what):
        '''List displaytag information'''
        if what == "color":
            self.printer.out("%sTag allowed colors:%s"%(color["lblue"],  color["reset"]))
            for c in color.keys():
                if c.isalpha():
                    self.printer.out(c)
        elif what == "type":
            self.printer.out("%sTag allowed types:%s"%(color["lblue"], color["reset"]))
            for t in self.cli.tagdisplay.types:
                self.printer.out(t)
        elif what == "my":
            self.printer.out("%sMy tag colors:%s"%(color["lblue"], color["reset"]))
            for (u,v) in self.cli.tagdisplay.tagcolor.items():
                self.printer.out("%s: %s"%(u,v))
            self.printer.out("%sMy tag tiltecolors:%s"%(color["lblue"], color["reset"]))
            for (u,v) in self.cli.tagdisplay.tagtitlecolor.items():
                self.printer.out("%s: %s"%(u,v))
            self.printer.out("%sMy tag types:%s"%(color["lblue"], color["reset"]))
            for (u,v) in self.cli.tagdisplay.tagtype.items():
                self.printer.out("%s: %s"%(u,v))
        else:
            raise AttributeError

    def set(self, what, tags, value):
        '''Set displaytag info'''
        # crazy gard
        if not len(tags) > 0:
            return
        # set appropriate database
        if what == "color":
            db = self.cli.tagdisplay.tagcolor
            vdb = [ c for c in color.keys() if c.isalpha() ]
        elif what == "titlecolor":
            db = self.cli.tagdisplay.tagtitlecolor
            vdb = [ c for c in color.keys() if c.isalpha() ]
        elif what == "type":
            db = self.cli.tagdisplay.tagtype
            vdb = self.cli.tagdisplay.types
        else:
            raise AttributeError
        # check attribute
        if value is not None and value not in vdb:
            self.printer.error("Invalid value: %s"%value)
            return
        # update db
        for tagname in tags:
            if value is None:
                if tagname in db:
                    del db[tagname]
            else:
                db[tagname] = value
        try:
            self.cli.tagdisplay.save(self.cli.settings.get("tagdisplay", None))
        except Exception as e:
            raise cmdError(e)
