#!/usr/bin/env python
#coding=utf8

'''
CloudControl tag releated commands
'''

from cccli.exception import *
from sjrpc.core.exceptions import *
from cccli.printer import Printer, color
from cccli.command.command import TqlCommand

from optparse import OptionParser

class Command_tags(TqlCommand):
    '''List only static tags'''

    def __init__(self, cli, argv0):
        TqlCommand.__init__(self, cli, argv0)
        self.set_usage("%prog [options] [tql]")
        self.remove_option("--quiet")
        self.remove_option("--direct")
        self.tql_filter += "&a"

    def __call__(self, argv):
        # Parse argline
        self.parse_args(argv)
        # append current login if nothing asked
        if len(self.args) == 0:
            tql = "a=%s"%self.cli.settings["login"]
        else:
            tql = "".join(self.args)
        # ask server
        objs = self.rpccall("tags", tql, _direct=True, _status=False)
        # display answer
        for o in objs:
            tid = self.tdr("id", o.pop("id"))
            tags = " ".join([ "%s%s:%s%s"%(self.tdtc(t),
                                           t,
                                           self.tdc(t),
                                           self.tdr(t, v))
                              for (t,v) in o.items() ])
            self.printer.out("%sid=%s%s %s%s"%(self.tdtc("id"), self.tdc("id"), tid, tags, color["reset"]))


class Command_addtag(TqlCommand):
    '''Add/Modify a static tag on an account'''

    def __init__(self, cli, argv0):
        TqlCommand.__init__(self, cli, argv0)
        self.tql_filter += "&a"
        self.set_usage("%prog [options] <tql> <tag> <value>")

    def __call__(self, argv):
        # argv check
        self.parse_args(argv)
        if len(self.args) != 3:
            raise cmdBadArgument()
        # rpc call
        self.rpccall("addtag", self.args[0], self.args[1], self.args[2])


class Command_deltag(TqlCommand):
    '''Delete a static tag from an account'''

    def __init__(self, cli, argv0):
        TqlCommand.__init__(self, cli, argv0)
        self.tql_filter += "&a"
        self.set_usage("%prog [options] <tql> <tag>")

    def __call__(self, argv):
        # argv check
        self.parse_args(argv)
        if len(self.args) != 2:
            raise cmdBadArgument()
        # rpc call
        self.rpccall("deltag", self.args[0], self.args[1])
