.TH CC-CLI "MARCH 2011" LINUX "MANUEL UTILISATEUR"
.SH NAME
cc-cli - Command Line Interface to CloudControl
.SH SYNOPSIS
\fBcc-cli\fP [\fIOPTION\fP] [\fICOMMANDS\fP]

.SH DESCRIPTION
.TP
\fB--version\fP
show program's version number and exit
.TP 
\fB-h\fP, \fB--help\fP
show this help message and exit
.TP
\fB-d\fP, \fB--debug\fP
Debug mode
.TP
\fB-D\fP, \fB--no-debug\fP
Unset debug mode
.TP
\fB-L\fP \fILOGIN\fP, \fB--login=\fP\fILOGIN\fP
Server login
.TP
\fB-H\fP \fISERVER\fP, \fB--hostname=\fP\fISERVER\fP
Server hostname
.TP
\fB-P\fP \fIPORT\fP, \fB--port=\fP\fIPORT\fP
Server port
.TP
\fB-t\fP \fITIMEOUT\fP, \fB--timeout=\fP\fITIMEOUT\fP
Connection timeout
.TP
\fB-p\fP \fIPROFILE\fP, \fB--profile=\fP\fIPROFILE\fP
Profile name
.TP
\fB-l\fP, \fB--list-profile\fP
List available profile
.TP
\fB--history-file=\fP\fIHISTORY\fP
History file
.TP
\fB--history-size=\fP\fIHSIZE\fP
History max entry count

.SS Loading procedure:
Configuration is loaded in this order:
.br
1 Check \fBCC_DEBUG\fP, to set early debugging mode
.br
2 load [cli] profile from \fB~/.config/cc-cli/profile\fP
.br
3 load profile specified by option profile (arg line, env, cli profile)
.br
4 load options from environment
.br
5 load options from command line

.SH TQL
TQL (text query language)
.br
- TQL build a list of objects in one query
.br
- An object is a list of tags
.br
- TQL can select and sort object by tags
.br
- TQL can choose tags in object
.br
- TQL can limit number of objects to select
.br
- TQL is a list statement mixed by separators
.br
- TQL build his object list from left to right (left parenthesis)
.br
- Each statement update the builded list regarding his separators
.br
- Selecting, sorting and showing separators are followed by tags
.br
- Limiting separators are followed by limiting conditions
.br
- TQL always return id tag
.br
- By default separators is &
.br
- By default object list is sorted id
.br

.SS SEPERATORS
\fB&\fP selection intersection
.br
\fB|\fP selection union
.br
\fB^\fP selection limit
.br
\fB$\fP tag showing
.br
\fB%\fP tag sorting

.SS OPERATORS
\fB=\fP strict equality
.br
\fB:\fP globing matching (no case)
.br
\fB~\fP regex matching
.br
\fB>\fP superior strict
.br
\fB>=\fP superior
.br
\fB<\fP inferior
.br
\fB<=\fP inferior strict
.br
Each previous operators can be negated by adding \fB!\fP before it.

.SS LIMITING CONDITIONS
\fBn\fP limit to n first objects
.br
\fB,n\fP limit from n objects to last object

.SS NUMBER FACILITY
\fB10k\fP = 1000
.br
\fB10ki\fP = 1024
.br
\fB1m\fP = 1000 ^ 2
.br
\fB1mi\fP = 1024 ^ 2
.br
\fB1g\fP = 1000 ^ 3
.br
\fB1gi\fP = 1024 ^ 3

.SS EXAMPLE
For example, See the command \fBlist\fP

.SH GENERIC COMMANDS

.SS addaccount [\fIoptions\fP] \fI<account-name> <role>\fP [\fIpassword\fP]
.TP
Create an account
.TP
\fBOptions:\fP
.TP
  \fB-h\fP, \fB-help\fP
show this help message and exit
.TP
  \fB-q\fP, \fB--quiet\fP
Don't status of call request
.TP
  \fB-i\fP, \fB--index\fP
Print TQL line index
.TP
  \fB--print-tql\fP
Print TQL before sending to server
.TP
  \fB--no-tagdisplay\fP
No tagdisplay custom display
.TP
  \fB--no-color\fP
No output coloration
.TP
\fBExample:\fP
.TP
  \fBaddacount toto cli azerty\fP
Create account toto in role cli (user) whith password azerty

.SS addright [\fIoptions\fP] \fI<account tql> <right tql> <method> <target>\fP [\fIindex\fP]
Add or edit account right
.br
All is deny by default
.br
When a user tape a command, cli check the rights from index 0, if the method and the right tql match whith command, right is applied, else it check the next rights, and if not found a matching rights, it deny the command
.TP
Example:
\fB[0] tql: method:* target:allow\fP
.br
\fB[1] tql: method:list target:deny\fP
.br
  if the user tape the command \fBlist\fP whith any tql, the command will be allowed because it matches with index 0

\fB[0] tql: method:list target:deny\fP
.br
\fB[1] tql: method:* target:allow\fP
.br
  if the user tape the command \fBlist\fP whith any tql, the command will be denied because it matches with index 0

.TP
\fI<method>\fP
is the name of the rpc command to allow
.TP
\fI<target>\fP
can be allow or deny
.TP
\fBOptions:\fP
.TP
  \fB-h\fP, \fB--help\fP
show this help message and exit
.TP
  \fB-r\fP, \fB--raw\fP
Don't append security filter to TQL
.TP
  \fB-d\fP, \fB--direct\fP
Directly send TQL to server
.TP
  \fB-q\fP, \fB--quiet\fP
Don't status of call request
.TP
  \fB-i\fP, \fB--index\fP
Print TQL line index
.TP
  \fB--print-tql\fP
Print TQL before sending to server
.TP
  \fB--no-tagdisplay\fP
No tagdisplay custom display
.TP
  \fB--no-color\fP
No output coloration
.TP
\fBExample\fP
  \fBaddright id=toto "" * allow 0\fP
.br
    Allow all method whith all query tql in index 0 for account toto

  \fBaddright id=toto "id=toto" list deny 0\fP
.br
    Deny method list whith tql "id=toto" for account toto in index 0 (deny commands' example: list id=toto, list id:t*, ...)

.SS alias [\fIoptions\fP] [\fIname\fP] [\fIvalue\fP]
.TP
Show or create alias
.TP
CLI support aliasing. This is a very useful command substitution. Alias is stored in \fB~/.config/cc-cli/alias\fP
.TP
\fBOptions:\fP
.TP
  \fB-h\fP, \fB--help\fP
show this help message and exit
.TP
\fBExample:\fP
.TP
  \fBalias w "list a&con!=offline&r=cli"\fP
Setting an alias w, which list online client
.TP
  \fBalias vm "list r=vm&status=running$cpu"\fP
Setting an alias vm, which list running vm (and show cpu)

.SS clear
.TP
Clear tty

.SS close [\fIoptions\fP] \fI<tql>\fP
.TP
Disable accounts
.TP
\fBOptions:\fP
.TP
  \fB-h\fP, \fB--help\fP
show this help message and exit
.TP
  \fB-r\fP, \fB--raw\fP
Don't append security filter to TQL
.TP
  \fB-d\fP, \fB--direct\fP
Directly send TQL to server
.TP
  \fB-q\fP, \fB--quiet\fP
Don't status of call request
.TP
  \fB-i\fP, \fB--index\fP
Print TQL line index
.TP
  \fB--print-tql\fP
Print TQL before sending to server
.TP
  \fB--no-tagdisplay\fP
No tagdisplay custom display
.TP
  \fB--no-color\fP
No output coloration

.SS declose [\fIoptions\fP] \fI<tql>\fP
.TP
Enable accounts
.TP
\fBOptions:\fP
.TP
  \fB-h\fP, \fB--help\fP
show this help message and exit
.TP
  \fB-r\fP, \fB--raw\fP
Don't append security filter to TQL
.TP
  \fB-d\fP, \fB--direct\fP
Directly send TQL to server
.TP
  \fB-q\fP, \fB--quiet\fP
Don't status of call request
.TP
  \fB-i\fP, \fB--index\fP
Print TQL line index
.TP
  \fB--print-tql\fP
Print TQL before sending to server
.TP
  \fB--no-tagdisplay\fP
No tagdisplay custom display
.TP
  \fB--no-color\fP
No output coloration

.SS delaccount [\fIoptions\fP] \fI<tql>\fP
.TP
Delete an account
.TP
\fBOptions:\fP
.TP
  \fB-h\fP, \fB--help\fP
show this help message and exit
.TP
  \fB-r\fP, \fB--raw\fP
Don't append security filter to TQL
.TP
  \fB-d\fP, \fB--direct\fP
Directly send TQL to server
.TP
  \fB-q\fP, \fB--quiet\fP
Don't status of call request
.TP
\fB-i\fP, \fB--index\fP
Print TQL line index
.TP
  \fB--print-tql\fP
Print TQL before sending to server
.TP
  \fB--no-tagdisplay\fP
No tagdisplay custom display
.TP
  \fB--no-color\fP
No output coloration

.SS delright [\fIoptions\fP] \fI<tql> <index>\fP
.TP
Delete account right

.TP
\fI<index>\fP
* means all
.TP
\fBOptions:\fP
.TP
  \fB-h\fP, \fB--help\fP
show this help message and exit
.TP
  \fB-r\fP, \fB--raw\fP
Don't append security filter to TQL
.TP
  \fB-d\fP, \fB--direct\fP
Directly send TQL to server
.TP
  \fB-q\fP, \fB--quiet\fP
Don't status of call request
.TP
  \fB-i\fP, \fB--index\fP
Print TQL line index
.TP
  \fB--print-tql\fP
Print TQL before sending to server
.TP
  \fB--no-tagdisplay\fP
No tagdisplay custom display
.TP
  \fB--no-color\fP
No output coloration

.TP
\fBNotes:\fP
.TP
  if you have deny rights in the command list, for delete account right, you must use options --raw and -direct
\fBdelright -r -d id=toto x\fP


.SS expert
Switch in expert mode

Expert mode history is stored in \fB~/.local/share/cc-cli/expert\fP


.SS help
.TP
Print help


.SS history
.TP
Show commands history

CLI history is stored in \fB~/.local/share/cc-cli/history\fP


.SS kill [\fIoptions\fP] \fI<tql>\fP
.TP
Kill a server connection
.TP
\fBOptions:\fP
.TP
  \fB-h\fP, \fB--help\fP
show this help message and exit
.TP
  \fB-r\fP, \fB--raw\fP
Don't append security filter to TQL
.TP
  \fB-d\fP, \fB--direct\fP
Directly send TQL to server
.TP
  \fB-q\fP, \fB--quiet\fP
Don't status of call request
.TP
  \fB-i\fP, \fB--index\fP
Print TQL line index
.TP
  \fB--print-tql\fP
Print TQL before sending to server
.TP
  \fB--no-tagdisplay\fP
No tagdisplay custom display
.TP
  \fB--no-color\fP
No output coloration


.SS list [\fIoptions\fP] [\fItql\fP]
.TP
List objects
.TP
\fBOptions:\fP
.TP
  \fB-h\fP, \fB--help\fP
show this help message and exit
.TP
  \fB-r\fP, \fB--raw\fP
Don't append security filter to TQL
.TP
  \fB-i\fP, \fB--index\fP
Print TQL line index
.TP
  \fB--print-tql\fP
Print TQL before sending to server
.TP
  \fB--no-tagdisplay\fP
No tagdisplay custom display
.TP
  \fB--no-color\fP
No output coloration
.TP
  \fB-t\fP
column aligment display
.TP
  \fB-l\fP
line aligment display

.P
\fBExample:\fP
.br
  \fBlist\fP
.br
    list all accounts

  \fBlist h:fw*\fP
.br
    list all hostname starting by fw

  \fBlist r=hv\fP
.br
    list all hypervisor

  \fBlist r=vm\fP
.br
    list all vm

  \fBlist hv=toto\fP
.br
    list vm of hypervisor toto

  \fBlist r=vm&cpu=2\fP
.br
    list vm with 2 cpu

  \fBlist r=vm&cpu=2&mem>10g\fP
.br
    list vm with 2 cpu and mem > 10g

  \fBlist r=hv&cpu=2&mem>10g\fP
.br
    list hypervisor with no vm

  \fBlist cpu>=2$pop$alloc\fP
.br
    list object with at least 2cpu and show tags pop and alloc

  \fBlist r=vm^10\fP
.br
    list first 10 vm

  \fBlist r=vm%cpu\fP
.br
    list vm sorted by cpu


.SS passwd [\fIoptions\fP] [\fItql\fP] [\fIpassword\fP]
.TP
Change account password
.TP
\fBOptions:\fP
.TP
  \fB-h\fP, \fB--help\fP
show this help message and exit
.TP
  \fB-r\fP, \fB--raw\fP
Don't append security filter to TQL
.TP
  \fB-d\fP, \fB--direct\fP
Directly send TQL to server
.TP
  \fB-q\fP, \fB--quiet\fP
Don't status of call request
.TP
  \fB-i\fP, \fB--index\fP
Print TQL line index
.TP
  \fB--print-tql\fP
Print TQL before sending to server
.TP
  \fB--no-tagdisplay\fP
No tagdisplay custom display
.TP
  \fB--no-color\fP
No output coloration


.SS quit
.TP
Quit application with respect


.SS rights [\fIoptions\fP] [\fItql\fP]
.TP
List account rights
.TP
\fBOptions:\fP
.TP
  \fB-h\fP, \fB--help\fP
show this help message and exit
.TP
  \fB-r\fP, \fB--raw\fP
Don't append security filter to TQL
.TP
  \fB--print-tql\fP
Print TQL before sending to server
.TP
  \fB--no-tagdisplay\fP
No tagdisplay custom display
.TP
\fBExample:\fP
\fB>>right id=toto\fP
.br
  a:toto
.br
  [0] tql:id=toto method:list target:deny

Display right for account with id toto.
.br
The user toto doesn't have right use method list whith a tql conained "id=toto" (deny commands' example: list id=toto, list id:t*, ...)

.SS server \fI<options>\fP
.TP
Server manipulation command
.TP
\fBOptions:\fP
.TP
  \fB-h\fP, \fB--help\fP
show this help message and exit
.TP
  \fB-c\fP
show server cache
.TP
  \fB-f\fP
show server functions
.TP
  \fB-v\fP
show server version


.SS shutdown [\fIoptions\fP] \fI<tql>\fP
.TP
Shutdown a physical host
.TP
\fBOptions:\fP
.TP
  \fB-h\fP, \fB--help\fP
show this help message and exit
.TP
  \fB-r\fP, \fB--raw\fP
Don't append security filter to TQL
.TP
  \fB-d\fP, \fB--direct\fP
Directly send TQL to server
.TP
  \fB-q\fP, \fB--quiet\fP
Don't status of call request
.TP
  \fB-i\fP, \fB--index\fP
Print TQL line index
.TP
  \fB--print-tql\fP
Print TQL before sending to server
.TP
  \fB--no-tagdisplay\fP
No tagdisplay custom display
.TP
  \fB--no-color\fP
No output coloration
.TP
  \fB-R\fP, \fB--reboot\fP
Reboot after shutdown (default)
.TP
  \fB-H\fP, \fB--halt\fP
Halt after shutdown
.TP
  \fB-F\fP
do not go through init but go down real fast


.SS unalias [\fIoptions\fP] [\fIname\fP]
.TP
Remove an alias
.TP
\fBOptions:\fP
.TP
  \fB-h\fP, \fB--help\fP
show this help message and exit

.SS usage \fI<command>\fP
.TP
Print usage of a command

.SS version
.TP
Print cli version

.SS whoami
.TP
Show connection login

.SH TAG COMMANDS

Every tag is composed by a tagname and a tagvalue
.br
- Tagname are case insensitive, tagvalue is case sensitive
.br
- You can use globin on tagname
.br
- tagname starting by - means all tag except this one
.br
- Operators machtes on tagvalues


./certain tag sont reservé et ne peuvent etre cree modfie ou supprimer par le client
.SS RESERVERD TAGS
Reserved tags are tags with a special meaning and cannot be set or remove directly by clients
.br 
\fBid\fP : object unique identifier (eg: kvmlab-1.test5)
.br 
\fBp\fP : parent object identifier (eg: kvmlab-1)
.br 
\fBa\fP : account name (eg: bobby)
.br 
\fBr\fP : account role (host/hv/vm/cli/web/spv)
.br 
\fBclosed\fP : account close status
.br 
\fBcon\fP : connection uptime in seconds (eg: 3600)
.br 
\fBip\fP : ipv4 of connection

.SS WELL KNOWN TAGS
\fBh\fP : hostname (eg: access)
.br 
\fBhv\fP : hypervisor name (eg: kvmlab-1)
.br 
\fBhtype\fP : hypervisor type (xen/kvm)
.br 
\fBlibvirtver\fP : Libvirt version
.br 
\fBstatus\fP : VM status (running/paused/stopped)
.br 
\fBcpu\fP : cpu count
.br 
\fBrcpu\fP : reserved cpu count
.br 
\fBmem\fP : memory total size
.br 
\fBmemused\fP : memory used
.br 
\fBmemfree\fP : memory free
.br 
\fBarch\fP : hardware architecture (x86/x64)
.br 
\fBuname\fP : output of uname command
.br 
\fBuptime\fP : uptime of hostname
.br 
\fBload\fP : load average
.br 
\fBos\fP: operating system (linux/windows)
.br 
\fBalloc\fP : host is allowed to be selected to a migration
.br 
\fBhvm\fP : hardware virtualisation enabled
.br 
\fBnvm\fP : vm count on an hypervisor
.br 
\fBvmstarted\fP : started vm count on an hypervisor
.br 
\fBvmstopped\fP : stopped vm count on an hypervisor
.br 
\fBvmpaused\fP : paused vm count on an hypervisor
.br 
\fBversion\fP : account reported version
.br 
\fBsto\fP : storage pool names (eg: vg fg)
.br 
\fBstovg_type\fP : vg storage pool type (eg: lvm)
.br 
\fBstovg_size\fP : vg storage pool size (eg: 1042)
.br 
\fBstovg_used\fP : vg storage pool used space (eg: 1)
.br 
\fBstovg_free\fP : vg storage pool free space (eg: 1041)
.br 
\fBstovg_path\fP : vg storage pool path (eg: /dev/vg/)
.br 
\fBstovg_vol\fP : vg storage pool volume list (eg: sex titi toto)
.br 
\fBdisk: disk\fP  index list (eg: 1 2 3 4)
.br 
\fBdisk1_path\fP : disk 1 path (eg: /dev/vg/sex)
.br 
\fBdisk1_size\fP : disk 1 size (eg: 1024)
.br 
\fBdisk1_pool\fP : storage pool back reference (eg: vg) [vmonly]
.br 
\fBdisk1_vol\fP : storage pool volume back reference (eg: titi) [vmonly]
.br 
\fBvncport\fP : vnc local port (eg: 5001)
.br 
\fBhvver\fP : hypervisor version (eg: 0.14)
.br 
\fBhserial\fP : host serial number (eg: Dell service tag)
.br 
\fBhvendor\fP : host vendor (eg: Dell Computer Corporation)
.br 
\fBhmodel\fP : host model (eg: PowerEdge 2850)
.br 
\fBhbios\fP : host bios version and/or date (eg: A05 (01/09/2006))
.br 
\fBcputhread\fP : total number of cpu thread
.br 
\fBcpufreq\fP : cpu core frequency
.br 
\fBcpuuse\fP : global cpu usage (percentage)
.br 
\fBplatform\fP : python platform info
.br 
\fBchaserial\fP : blade chassis serial number (dell tag)
.br 
\fBchaasset\fP : blade chassis asset tag (dell tag)


.SS addtag [\fIoptions\fP] \fI<tql> <tag> <value>\fP
.TP
Add/Modify a static tag on an account
.TP
\fBOptions:\fP
.TP
  \fB-h\fP, \fB--help\fP
show this help message and exit
.TP
  \fB-r\fP, \fB--raw\fP
Don't append security filter to TQL
.TP
  \fB-d\fP, \fB--direct\fP
Directly send TQL to server
.TP
  \fB-q\fP, \fB--quiet\fP
Don't status of call request
.TP
  \fB-i\fP, \fB--index\fP
Print TQL line index
.TP
  \fB--print-tql\fP
Print TQL before sending to server
.TP
  \fB--no-tagdisplay\fP
No tagdisplay custom display
.TP
  \fB--no-color\fP
No output coloration
.TP
\fBExample:\fP
.TP
  \fBaddtag id=toto hello foo\fP
Create tag hello whith value foo in the account toto
.TP
  \fBaddtag r=vm hello foo\fP
Create tag hello whith value foo in all vm


.SS deltag [\fIoptions\fP] \fI<tql> <tag>\fP
Delete a static tag from an account
.TP
  \fBOptions:\fP
.TP
  \fB-h\fP, \fB--help\fP
show this help message and exit
.TP
  \fB-r\fP, \fB--raw\fP
Don't append security filter to TQL
.TP
  \fB-d\fP, \fB--direct\fP
Directly send TQL to server
.TP
  \fB-q\fP, \fB--quiet\fP
Don't status of call request
.TP
  \fB-i\fP, \fB--index\fP
Print TQL line index
.TP
  \fB--print-tql\fP
Print TQL before sending to server
.TP
  \fB--no-tagdisplay\fP
No tagdisplay custom display
.TP
  \fB--no-color\fP
No output coloration
.TP
\fBExample:\fP
.TP
  \fBdeltag id=toto hello\fP
Delete tag hello from account toto

.SS tagdisplay [\fIoptions\fP] [\fItag\fP] ...
Tagdisplay tool
.TP
\fBOptions:\fP
.TP
  \fB-h\fP, \fB--help\fP
show this help message and exit
.TP
  \fB-c\fP \fISET-COLOR\fP
Set custom color on [\fItag\fP]
.TP
  \fB-C\fP
Remove custom color on [\fItag\fP]
.TP
  \fB-t\fP \fISET-TYPE\fP
Set custom type on [\fItag\fP]
.TP
  \fB-T\fP
Remove custom type on [\fItag\fP]
.TP
  \fB-f\fP \fISET-TITLE-COLOR\fP
Set custom title color on [\fItag\fP]
.TP
  \fB-F\fP
Remove custom title color on [\fItag\fP]
.TP
  \fB--list-colors\fP
List allowed color
.TP
  \fB--list-types\fP
List allowed types

.SS tags [\fIoptions\fP] [\fItql\fP]
List only static tags
.TP
\fBOptions:\fP
.TP
  \fB-h\fP, \fB--help\fP
show this help message and exit
.TP
  \fB-r\fP, \fB--raw\fP
Don't append security filter to TQL
.TP
  \fB-i\fP, \fB--index\fP
Print TQL line index
.TP
  \fB--print-tql\fP
Print TQL before sending to server
.TP
  \fB--no-tagdisplay\fP
No tagdisplay custom display
.TP
  \fB--no-color\fP
No output coloration

.SH JOB COMMANDS

.SS cancel [\fIoptions\fP] \fI<job_id>\fP ...
Cancel a job
.TP
\fBOptions:\fP
.TP
  \fB-h\fP, \fB--help\fP
show this help message and exit

.SS destroy [\fIoptions\fP] \fI<tql>\fP
Force a vm to stop

Immediately terminate the VM.  This doesn't give the domain OS any chance to
react, and it's the equivalent of ripping the power cord out on a physical machine.  In most
cases you will want to use the stop command instead.

.TP
\fBOptions:\fP
.TP
  \fB-h\fP, \fB--help\fP
show this help message and exit
.TP
  \fB-r\fP, \fB--raw\fP
Don't append security filter to TQL
.TP
  \fB-d\fP, \fB--direct\fP
Directly send TQL to server
.TP
  \fB-q\fP, \fB--quiet\fP
Don't status of call request
.TP
  \fB-i\fP, \fB--index\fP
Print TQL line index
.TP
  \fB--print-tql\fP
Print TQL before sending to server
.TP
  \fB--no-tagdisplay\fP
No tagdisplay custom display
.TP
  \fB--no-color\fP
No output coloration

.SS execute [\fIoptions\fP] \fI<tql> <command>\fP
Execute a command on the remote host
.TP
\fBOptions:\fP
.TP
  \fB-h\fP, \fB--help\fP
show this help message and exit
.TP
  \fB-r\fP, \fB--raw\fP
Don't append security filter to TQL
.TP
  \fB-d\fP, \fB--direct\fP
Directly send TQL to server
.TP
  \fB-q\fP, \fB--quiet\fP
Don't status of call request
.TP
  \fB-i\fP, \fB--index\fP
Print TQL line index
.TP
  \fB--print-tql\fP
Print TQL before sending to server
.TP
  \fB--no-tagdisplay\fP
No tagdisplay custom display
.TP
  \fB--no-color\fP
No output coloration


.SS jobs [\fIoptions\fP] [\fItql\fP]
List jobs
.TP
\fBOptions:\fP
.TP
  \fB-h\fP, \fB--help\fP
show this help message and exit
.TP
  \fB-r\fP, \fB--raw\fP
Don't append security filter to TQL
.TP
  \fB-i\fP, \fB--index\fP
Print TQL line index
.TP
  \fB--print-tql\fP
Print TQL before sending to server
.TP
  \fB--no-tagdisplay\fP
No tagdisplay custom display
.TP
  \fB--no-color\fP
No output coloration
.TP
  \fB-d\fP, \fB--done\fP
Show done jobs
.TP
  \fB-R\fP, \fB--no-running\fP
Don't show running jobs

.SS migrate [\fIoptions\fP] [\fIsource-tql\fP] [\fIdest-tql\fP]
Migrate vm
.TP
\fBOptions:\fP
.TP
  \fB-h\fP, \fB--help\fP
show this help message and exit
.TP
  \fB-q\fP, \fB--quiet\fP
Don't status of call request
.TP
  \fB-i\fP, \fB--index\fP
Print TQL line index
.TP
  \fB--no-tagdisplay\fP
No tagdisplay custom display
.TP
  \fB--no-color\fP
No output coloration
.TP
  \fB-l\fP, \fB--list\fP
List migration types and algo
.TP
  \fB-t\fP \fITYPE\fP, \fB--type=\fP\fITYPE\fP
Selection migration type
.TP
  \fB-a\fP \fIALGO\fP, \fB--algo=\fP\fIALGO\fP
Select migration algorithm
.TP
\fBExample:\fP
.TP
  \fBmigrate r=vm&p=host1 id=host2\fP
Migrate all vm in host1 to host2

.SS pause [\fIoptions\fP] \fI<tql>\fP
Pause a running vm
.TP
\fBOptions:\fP
.TP
  \fB-h\fP, \fB--help\fP
show this help message and exit
.TP
  \fB-r\fP, \fB--raw\fP
Don't append security filter to TQL
.TP
  \fB-d\fP, \fB--direct\fP
Directly send TQL to server
.TP
  \fB-q\fP, \fB--quiet\fP
Don't status of call request
.TP
  \fB-i\fP, \fB--index\fP
Print TQL line index
.TP
  \fB--print-tql\fP
Print TQL before sending to server
.TP
  \fB--no-tagdisplay\fP
No tagdisplay custom display
.TP
  \fB--no-color\fP
No output coloration
.TP
\fBExample\fP
.TP
  \fBpause r=vm&status=running&p=host1\fP
Pause all vm started in the hypervisor host1

.SS resume [\fIoptions\fP] \fI<tql>\fP
Resume a paused vm

This will allow a previously paused vm to
now be eligible for scheduling by the underlying hypervisor.

.TP
\fBOptions:\fP
.TP
  \fB-h\fP, \fB--help\fP
show this help message and exit
.TP
  \fB-r\fP, \fB--raw\fP
Don't append security filter to TQL
.TP
  \fB-d\fP, \fB--direct\fP
Directly send TQL to server
.TP
  \fB-q\fP, \fB--quiet\fP
Don't status of call request
.TP
  \fB-i\fP, \fB--index\fP
Print TQL line index
.TP
  \fB--print-tql\fP
Print TQL before sending to server
.TP
  \fB--no-tagdisplay\fP
No tagdisplay custom display
.TP
  \fB--no-color\fP
No output coloration

.SS start [\fIoptions\fP] \fI<tql>\fP
.TP
Start a stopped vm
.TP
\fBOptions:\fP
.TP
  \fB-h\fP, \fB--help\fP
show this help message and exit
.TP
  \fB-r\fP, \fB--raw\fP
Don't append security filter to TQL
.TP
  \fB-d\fP, \fB--direct\fP
Directly send TQL to server
.TP
  \fB-q\fP, \fB--quiet\fP
Don't status of call request
.TP
  \fB-i\fP, \fB--index\fP
Print TQL line index
.TP
  \fB--print-tql\fP
Print TQL before sending to server
.TP
  \fB--no-tagdisplay\fP
No tagdisplay custom display
.TP
  \fB--no-color\fP
No output coloration

.SS stop [\fIoptions\fP] \fI<tql>\fP
Stop a running vm

This coordinates with the domain OS to perform graceful 
stop, so there is no guarantee that it will succeed, and may take a variable length of
time depending on what services must be shutdown in the domain

.TP
\fBOptions:\fP
.TP
  \fB-h\fP, \fB--help\fP
show this help message and exit
.TP
  \fB-r\fP, \fB--raw\fP
Don't append security filter to TQL
.TP
  \fB-d\fP, \fB--direct\fP
Directly send TQL to server
.TP
  \fB-q\fP, \fB--quiet\fP
Don't status of call request
.TP
  \fB-i\fP, \fB--index\fP
Print TQL line index
.TP
  \fB--print-tql\fP
Print TQL before sending to server
.TP
  \fB--no-tagdisplay\fP
No tagdisplay custom display
.TP
  \fB--no-color\fP
No output coloration

.SH FILES
.TP
\fB~/.config/cc-cli/profile\fP
file where cli profile is stored
.TP
\fB~/.local/share/cc-cli/history\fP
file where cli history are stored
.TP
\fB~/.local/share/cc-cli/expert\fP
file where expert mode history are stored
.TP
\fB~/.config/cc-cli/alias\fP
file where alias are stored

.SH ENVIRONNEMENT
.TP
\fBCC_SERVER\fP
.TP
\fBCC_PORT\fP
.TP
\fBCC_LOGIN\fP
.TP
\fBCC_PASS\fP
.TP
\fBCC_DEBUG\fP
.TP
\fBCC_PROFILE\fP

.SH AUTHOR
SmartJog IT

