
'''
CloudControl VM related commands
'''

from cccli.exception import *
from sjrpc.core.exceptions import *
from cccli.printer import Printer, color
from cccli.command.command import TqlCommand

class Command_start(TqlCommand):
    '''Start a stopped vm'''

    def __init__(self, cli, argv0):
        TqlCommand.__init__(self, cli, argv0)
        self.tql_filter += "&r=vm&status=stopped"

    def __call__(self, argv):
        # arg parse
        self.parse_args(argv)
        if len(self.args) != 1:
            raise cmdBadArgument()
        # rpc call
        self.rpccall("start", self.args[0])


class Command_stop(TqlCommand):
    '''Stop a running vm'''

    def __init__(self, cli, argv0):
        TqlCommand.__init__(self, cli, argv0)
        self.tql_filter += "&r=vm&status=running"

    def __call__(self, argv):
        # arg parse
        self.parse_args(argv)
        if len(self.args) != 1:
            raise cmdBadArgument()
        # rpc call
        self.rpccall("stop", self.args[0])


class Command_destroy(TqlCommand):
    '''Force a vm to stop'''

    def __init__(self, cli, argv0):
        TqlCommand.__init__(self, cli, argv0)
        self.tql_filter += "&r=vm&status!=stopped"

    def __call__(self, argv):
        # arg parse
        self.parse_args(argv)
        if len(self.args) != 1:
            raise cmdBadArgument()
        # rpc call
        self.rpccall("destroy", self.args[0])


class Command_restart(TqlCommand):
    '''Restart a vm'''

    def __init__(self, cli, argv0):
        TqlCommand.__init__(self, cli, argv0)
        self.tql_filter += "&r=vm&status=running"

    def __call__(self, argv):
        # arg parse
        self.parse_args(argv)
        if len(self.args) != 1:
            raise cmdBadArgument()
        # rpc call
        self.rpccall("restart", self.args[0])


class Command_pause(TqlCommand):
    '''Pause a running vm'''

    def __init__(self, cli, argv0):
        TqlCommand.__init__(self, cli, argv0)
        self.tql_filter += "&r=vm&status=stopped"

    def __call__(self, argv):
        # arg parse
        self.parse_args(argv)
        if len(self.args) != 1:
            raise cmdBadArgument()
        # rpc call
        self.rpccall("pause", self.args[0])


class Command_resume(TqlCommand):
    '''Resume a paused vm'''

    def __init__(self, cli, argv0):
        TqlCommand.__init__(self, cli, argv0)
        self.tql_filter += "&r=vm&status=paused"

    def __call__(self, argv):
        # arg parse
        self.parse_args(argv)
        if len(self.args) != 1:
            raise cmdBadArgument()
        # rpc call
        self.rpccall("resume", self.args[0])
