#!/usr/bin/env python
#coding=utf8

'''
CloudControl accounts related commands
'''

from cccli.exception import *
from sjrpc.core.exceptions import *
from cccli.printer import Printer, color
from cccli.command.command import Command

class Command_addaccount(Command):
    '''Create an account'''

    def __call__(self, argv):
        if len(argv) != 3:
            raise cmdBadArgument()
        try:
            self.cli.rpc.call("addaccount", argv[1], argv[2])
        except RpcError as e:
            raise cmdError("RPCError: %s"%str(e))

    def usage(self):
        return "usage: addaccount <account name> <role>"

class Command_delaccount(Command):
    '''Delete an account'''

    def __call__(self, argv):
        if len(argv) != 2:
            raise cmdBadArgument()
        try:
            self.cli.rpc.call("delaccount", argv[1])
        except RpcError as e:
            raise cmdError("RPCError: %s"%str(e))

    def usage(self):
        return "usage: delaccount <tql>"


class Command_close(Command):
    '''Disable accounts'''

    def __call__(self, argv):
        if len(argv) != 2:
            raise cmdBadArgument()
        try:
            self.cli.rpc.call("close", argv[1])
        except RpcError as e:
            raise cmdError("RPCError: %s"%str(e))

    def usage(self):
        return "usage: close <tql>"


class Command_declose(Command):
    '''Enable accounts'''

    def __call__(self, argv):

        if len(argv) != 2:
            raise cmdBadArgument()
        try:
            self.cli.rpc.call("declose", argv[1])
        except RpcError as e:
            raise cmdError("RPCError: %s"%str(e))

    def usage(self):
        return "usage: declose <tql>"


class Command_passwd(Command):
    '''Change account password'''

    def __call__(self, argv):
        if len(argv) == 1:
            argv.append("a=%s"%self.cli.settings["login"])
        if len(argv) == 2:
            a = self.printer.getpass("Password: ")
            b = self.printer.getpass("Again: ")
            if a != b:
                raise cmdError("You don't type twice the same password. Aborted")
            argv.append(a)
        elif len(argv) == 3:
            if self.cli.interactive:
                s = "You cannot set password with clear argument in interactive mode.\n"
                s += "*** Think to clean your history! ***"
                raise cmdError(s)
        else:
            raise cmdBadArgument()
        try:
            self.cli.rpc.call("passwd", argv[1], argv[2])
        except RpcError as e:
            raise cmdError("RPCError: %s"%str(e))

    def usage(self):
        return "usage: passwd [tql] [password]"
